<?php

namespace EnumType;

/**
 * This class stands for RequestStatus EnumType
 * @subpackage Enumerations
 */
class RequestStatus
{
    /**
     * Constant for value 'RequestMade'
     * @return string 'RequestMade'
     */
    const VALUE_REQUEST_MADE = 'RequestMade';
    /**
     * Constant for value 'RequestQueued'
     * @return string 'RequestQueued'
     */
    const VALUE_REQUEST_QUEUED = 'RequestQueued';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_REQUEST_MADE
     * @uses self::VALUE_REQUEST_QUEUED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REQUEST_MADE,
            self::VALUE_REQUEST_QUEUED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
