<?php

namespace EnumType;

/**
 * This class stands for ItemIDType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: D : McKesson Canada item numberG : GTIN U : UPCC : Custom
 * @subpackage Enumerations
 */
class ItemIDType
{
    /**
     * Constant for value 'D'
     * @return string 'D'
     */
    const VALUE_D = 'D';
    /**
     * Constant for value 'G'
     * @return string 'G'
     */
    const VALUE_G = 'G';
    /**
     * Constant for value 'U'
     * @return string 'U'
     */
    const VALUE_U = 'U';
    /**
     * Constant for value 'C'
     * @return string 'C'
     */
    const VALUE_C = 'C';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_D
     * @uses self::VALUE_G
     * @uses self::VALUE_U
     * @uses self::VALUE_C
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_D,
            self::VALUE_G,
            self::VALUE_U,
            self::VALUE_C,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
