<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestByDate StructType
 * @subpackage Structs
 */
class RequestByDate extends AbstractStructBase
{
    /**
     * The CustomerNumber
     * @var int
     */
    public $CustomerNumber;
    /**
     * The DistributorIdentifier
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * @var string
     */
    public $DistributorIdentifier;
    /**
     * The StartDate
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * @var string
     */
    public $EndDate;
    /**
     * Constructor method for RequestByDate
     * @uses RequestByDate::setCustomerNumber()
     * @uses RequestByDate::setDistributorIdentifier()
     * @uses RequestByDate::setStartDate()
     * @uses RequestByDate::setEndDate()
     * @param int $customerNumber
     * @param string $distributorIdentifier
     * @param string $startDate
     * @param string $endDate
     */
    public function __construct($customerNumber = null, $distributorIdentifier = null, $startDate = null, $endDate = null)
    {
        $this
            ->setCustomerNumber($customerNumber)
            ->setDistributorIdentifier($distributorIdentifier)
            ->setStartDate($startDate)
            ->setEndDate($endDate);
    }
    /**
     * Get CustomerNumber value
     * @return int|null
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }
    /**
     * Set CustomerNumber value
     * @param int $customerNumber
     * @return \StructType\RequestByDate
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: int
        if (!is_null($customerNumber) && !is_numeric($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerNumber)), __LINE__);
        }
        $this->CustomerNumber = $customerNumber;
        return $this;
    }
    /**
     * Get DistributorIdentifier value
     * @return string|null
     */
    public function getDistributorIdentifier()
    {
        return $this->DistributorIdentifier;
    }
    /**
     * Set DistributorIdentifier value
     * @param string $distributorIdentifier
     * @return \StructType\RequestByDate
     */
    public function setDistributorIdentifier($distributorIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($distributorIdentifier) && !is_string($distributorIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distributorIdentifier)), __LINE__);
        }
        $this->DistributorIdentifier = $distributorIdentifier;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\RequestByDate
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\RequestByDate
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RequestByDate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
