<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PromotionInformation_type StructType
 * @subpackage Structs
 */
class PromotionInformation_type extends AbstractStructBase
{
    /**
     * The PromotionNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxInclusive: 99999
     * - minInclusive: 0
     * @var int
     */
    public $PromotionNumber;
    /**
     * The DeliveryDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryDate;
    /**
     * The DeliveryCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 6
     * @var string
     */
    public $DeliveryCode;
    /**
     * Constructor method for PromotionInformation_type
     * @uses PromotionInformation_type::setPromotionNumber()
     * @uses PromotionInformation_type::setDeliveryDate()
     * @uses PromotionInformation_type::setDeliveryCode()
     * @param int $promotionNumber
     * @param string $deliveryDate
     * @param string $deliveryCode
     */
    public function __construct($promotionNumber = null, $deliveryDate = null, $deliveryCode = null)
    {
        $this
            ->setPromotionNumber($promotionNumber)
            ->setDeliveryDate($deliveryDate)
            ->setDeliveryCode($deliveryCode);
    }
    /**
     * Get PromotionNumber value
     * @return int|null
     */
    public function getPromotionNumber()
    {
        return $this->PromotionNumber;
    }
    /**
     * Set PromotionNumber value
     * @param int $promotionNumber
     * @return \StructType\PromotionInformation_type
     */
    public function setPromotionNumber($promotionNumber = null)
    {
        // validation for constraint: maxInclusive
        if ($promotionNumber > 99999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 99999, "%s" given', $promotionNumber), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($promotionNumber < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $promotionNumber), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($promotionNumber) && !is_numeric($promotionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($promotionNumber)), __LINE__);
        }
        $this->PromotionNumber = $promotionNumber;
        return $this;
    }
    /**
     * Get DeliveryDate value
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return $this->DeliveryDate;
    }
    /**
     * Set DeliveryDate value
     * @param string $deliveryDate
     * @return \StructType\PromotionInformation_type
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveryDate)), __LINE__);
        }
        $this->DeliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get DeliveryCode value
     * @return string|null
     */
    public function getDeliveryCode()
    {
        return $this->DeliveryCode;
    }
    /**
     * Set DeliveryCode value
     * @param string $deliveryCode
     * @return \StructType\PromotionInformation_type
     */
    public function setDeliveryCode($deliveryCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($deliveryCode) && strlen($deliveryCode) > 6) || (is_array($deliveryCode) && count($deliveryCode) > 6)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 6 element(s) or a scalar of 6 character(s) at most, "%d" length given', is_scalar($deliveryCode) ? strlen($deliveryCode) : count($deliveryCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($deliveryCode) && !is_string($deliveryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveryCode)), __LINE__);
        }
        $this->DeliveryCode = $deliveryCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PromotionInformation_type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
