<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderInformationRequest StructType
 * @subpackage Structs
 */
class OrderInformationRequest extends AbstractStructBase
{
    /**
     * The Authentication
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The OrderInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\OrderInformation_type[]
     */
    public $OrderInformation;
    /**
     * Constructor method for OrderInformationRequest
     * @uses OrderInformationRequest::setAuthentication()
     * @uses OrderInformationRequest::setOrderInformation()
     * @param \StructType\Authentication $authentication
     * @param \StructType\OrderInformation_type[] $orderInformation
     */
    public function __construct(\StructType\Authentication $authentication = null, array $orderInformation = array())
    {
        $this
            ->setAuthentication($authentication)
            ->setOrderInformation($orderInformation);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication|null
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\OrderInformationRequest
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get OrderInformation value
     * @return \StructType\OrderInformation_type[]|null
     */
    public function getOrderInformation()
    {
        return $this->OrderInformation;
    }
    /**
     * Set OrderInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderInformation_type[] $orderInformation
     * @return \StructType\OrderInformationRequest
     */
    public function setOrderInformation(array $orderInformation = array())
    {
        foreach ($orderInformation as $orderInformationRequestOrderInformationItem) {
            // validation for constraint: itemType
            if (!$orderInformationRequestOrderInformationItem instanceof \StructType\OrderInformation_type) {
                throw new \InvalidArgumentException(sprintf('The OrderInformation property can only contain items of \StructType\OrderInformation_type, "%s" given', is_object($orderInformationRequestOrderInformationItem) ? get_class($orderInformationRequestOrderInformationItem) : gettype($orderInformationRequestOrderInformationItem)), __LINE__);
            }
        }
        $this->OrderInformation = $orderInformation;
        return $this;
    }
    /**
     * Add item to OrderInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderInformation_type $item
     * @return \StructType\OrderInformationRequest
     */
    public function addToOrderInformation(\StructType\OrderInformation_type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderInformation_type) {
            throw new \InvalidArgumentException(sprintf('The OrderInformation property can only contain items of \StructType\OrderInformation_type, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OrderInformation[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderInformationRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
