<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LineItems StructType
 * @subpackage Structs
 */
class LineItems extends AbstractStructBase
{
    /**
     * The LineItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LineItem[]
     */
    public $LineItem;
    /**
     * Constructor method for LineItems
     * @uses LineItems::setLineItem()
     * @param \StructType\LineItem[] $lineItem
     */
    public function __construct(array $lineItem = array())
    {
        $this
            ->setLineItem($lineItem);
    }
    /**
     * Get LineItem value
     * @return \StructType\LineItem[]|null
     */
    public function getLineItem()
    {
        return $this->LineItem;
    }
    /**
     * Set LineItem value
     * @throws \InvalidArgumentException
     * @param \StructType\LineItem[] $lineItem
     * @return \StructType\LineItems
     */
    public function setLineItem(array $lineItem = array())
    {
        foreach ($lineItem as $lineItemsLineItemItem) {
            // validation for constraint: itemType
            if (!$lineItemsLineItemItem instanceof \StructType\LineItem) {
                throw new \InvalidArgumentException(sprintf('The LineItem property can only contain items of \StructType\LineItem, "%s" given', is_object($lineItemsLineItemItem) ? get_class($lineItemsLineItemItem) : gettype($lineItemsLineItemItem)), __LINE__);
            }
        }
        $this->LineItem = $lineItem;
        return $this;
    }
    /**
     * Add item to LineItem value
     * @throws \InvalidArgumentException
     * @param \StructType\LineItem $item
     * @return \StructType\LineItems
     */
    public function addToLineItem(\StructType\LineItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LineItem) {
            throw new \InvalidArgumentException(sprintf('The LineItem property can only contain items of \StructType\LineItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LineItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LineItems
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
