<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LineItem StructType
 * @subpackage Structs
 */
class LineItem extends AbstractStructBase
{
    /**
     * The OrderedItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrderedItem[]
     */
    public $OrderedItem;
    /**
     * The ShippedItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ShippedItem[]
     */
    public $ShippedItem;
    /**
     * Constructor method for LineItem
     * @uses LineItem::setOrderedItem()
     * @uses LineItem::setShippedItem()
     * @param \StructType\OrderedItem[] $orderedItem
     * @param \StructType\ShippedItem[] $shippedItem
     */
    public function __construct(array $orderedItem = array(), array $shippedItem = array())
    {
        $this
            ->setOrderedItem($orderedItem)
            ->setShippedItem($shippedItem);
    }
    /**
     * Get OrderedItem value
     * @return \StructType\OrderedItem[]|null
     */
    public function getOrderedItem()
    {
        return $this->OrderedItem;
    }
    /**
     * Set OrderedItem value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderedItem[] $orderedItem
     * @return \StructType\LineItem
     */
    public function setOrderedItem(array $orderedItem = array())
    {
        foreach ($orderedItem as $lineItemOrderedItemItem) {
            // validation for constraint: itemType
            if (!$lineItemOrderedItemItem instanceof \StructType\OrderedItem) {
                throw new \InvalidArgumentException(sprintf('The OrderedItem property can only contain items of \StructType\OrderedItem, "%s" given', is_object($lineItemOrderedItemItem) ? get_class($lineItemOrderedItemItem) : gettype($lineItemOrderedItemItem)), __LINE__);
            }
        }
        $this->OrderedItem = $orderedItem;
        return $this;
    }
    /**
     * Add item to OrderedItem value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderedItem $item
     * @return \StructType\LineItem
     */
    public function addToOrderedItem(\StructType\OrderedItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderedItem) {
            throw new \InvalidArgumentException(sprintf('The OrderedItem property can only contain items of \StructType\OrderedItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OrderedItem[] = $item;
        return $this;
    }
    /**
     * Get ShippedItem value
     * @return \StructType\ShippedItem[]|null
     */
    public function getShippedItem()
    {
        return $this->ShippedItem;
    }
    /**
     * Set ShippedItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ShippedItem[] $shippedItem
     * @return \StructType\LineItem
     */
    public function setShippedItem(array $shippedItem = array())
    {
        foreach ($shippedItem as $lineItemShippedItemItem) {
            // validation for constraint: itemType
            if (!$lineItemShippedItemItem instanceof \StructType\ShippedItem) {
                throw new \InvalidArgumentException(sprintf('The ShippedItem property can only contain items of \StructType\ShippedItem, "%s" given', is_object($lineItemShippedItemItem) ? get_class($lineItemShippedItemItem) : gettype($lineItemShippedItemItem)), __LINE__);
            }
        }
        $this->ShippedItem = $shippedItem;
        return $this;
    }
    /**
     * Add item to ShippedItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ShippedItem $item
     * @return \StructType\LineItem
     */
    public function addToShippedItem(\StructType\ShippedItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShippedItem) {
            throw new \InvalidArgumentException(sprintf('The ShippedItem property can only contain items of \StructType\ShippedItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ShippedItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LineItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
