<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceDownload StructType
 * @subpackage Structs
 */
class InvoiceDownload extends AbstractStructBase
{
    /**
     * The CustomerNumber
     * @var int
     */
    public $CustomerNumber;
    /**
     * The InvoiceNumber
     * @var int
     */
    public $InvoiceNumber;
    /**
     * The InvoiceDate
     * @var string
     */
    public $InvoiceDate;
    /**
     * The DistributorIdentifier
     * @var string
     */
    public $DistributorIdentifier;
    /**
     * Constructor method for InvoiceDownload
     * @uses InvoiceDownload::setCustomerNumber()
     * @uses InvoiceDownload::setInvoiceNumber()
     * @uses InvoiceDownload::setInvoiceDate()
     * @uses InvoiceDownload::setDistributorIdentifier()
     * @param int $customerNumber
     * @param int $invoiceNumber
     * @param string $invoiceDate
     * @param string $distributorIdentifier
     */
    public function __construct($customerNumber = null, $invoiceNumber = null, $invoiceDate = null, $distributorIdentifier = null)
    {
        $this
            ->setCustomerNumber($customerNumber)
            ->setInvoiceNumber($invoiceNumber)
            ->setInvoiceDate($invoiceDate)
            ->setDistributorIdentifier($distributorIdentifier);
    }
    /**
     * Get CustomerNumber value
     * @return int|null
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }
    /**
     * Set CustomerNumber value
     * @param int $customerNumber
     * @return \StructType\InvoiceDownload
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: int
        if (!is_null($customerNumber) && !is_numeric($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerNumber)), __LINE__);
        }
        $this->CustomerNumber = $customerNumber;
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * @return int|null
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }
    /**
     * Set InvoiceNumber value
     * @param int $invoiceNumber
     * @return \StructType\InvoiceDownload
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceNumber) && !is_numeric($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($invoiceNumber)), __LINE__);
        }
        $this->InvoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get InvoiceDate value
     * @return string|null
     */
    public function getInvoiceDate()
    {
        return $this->InvoiceDate;
    }
    /**
     * Set InvoiceDate value
     * @param string $invoiceDate
     * @return \StructType\InvoiceDownload
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceDate)), __LINE__);
        }
        $this->InvoiceDate = $invoiceDate;
        return $this;
    }
    /**
     * Get DistributorIdentifier value
     * @return string|null
     */
    public function getDistributorIdentifier()
    {
        return $this->DistributorIdentifier;
    }
    /**
     * Set DistributorIdentifier value
     * @param string $distributorIdentifier
     * @return \StructType\InvoiceDownload
     */
    public function setDistributorIdentifier($distributorIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($distributorIdentifier) && !is_string($distributorIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distributorIdentifier)), __LINE__);
        }
        $this->DistributorIdentifier = $distributorIdentifier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvoiceDownload
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
