<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Invoice StructType
 * @subpackage Structs
 */
class Invoice extends AbstractStructBase
{
    /**
     * The Header
     * @var \StructType\Header
     */
    public $Header;
    /**
     * The Parties
     * @var \StructType\Parties
     */
    public $Parties;
    /**
     * The PaymentTerms
     * @var \StructType\PaymentTerms
     */
    public $PaymentTerms;
    /**
     * The AllowanceCharges
     * @var \StructType\AllowanceCharges
     */
    public $AllowanceCharges;
    /**
     * The LineItems
     * @var \StructType\LineItems
     */
    public $LineItems;
    /**
     * Constructor method for Invoice
     * @uses Invoice::setHeader()
     * @uses Invoice::setParties()
     * @uses Invoice::setPaymentTerms()
     * @uses Invoice::setAllowanceCharges()
     * @uses Invoice::setLineItems()
     * @param \StructType\Header $header
     * @param \StructType\Parties $parties
     * @param \StructType\PaymentTerms $paymentTerms
     * @param \StructType\AllowanceCharges $allowanceCharges
     * @param \StructType\LineItems $lineItems
     */
    public function __construct(\StructType\Header $header = null, \StructType\Parties $parties = null, \StructType\PaymentTerms $paymentTerms = null, \StructType\AllowanceCharges $allowanceCharges = null, \StructType\LineItems $lineItems = null)
    {
        $this
            ->setHeader($header)
            ->setParties($parties)
            ->setPaymentTerms($paymentTerms)
            ->setAllowanceCharges($allowanceCharges)
            ->setLineItems($lineItems);
    }
    /**
     * Get Header value
     * @return \StructType\Header|null
     */
    public function getHeader()
    {
        return $this->Header;
    }
    /**
     * Set Header value
     * @param \StructType\Header $header
     * @return \StructType\Invoice
     */
    public function setHeader(\StructType\Header $header = null)
    {
        $this->Header = $header;
        return $this;
    }
    /**
     * Get Parties value
     * @return \StructType\Parties|null
     */
    public function getParties()
    {
        return $this->Parties;
    }
    /**
     * Set Parties value
     * @param \StructType\Parties $parties
     * @return \StructType\Invoice
     */
    public function setParties(\StructType\Parties $parties = null)
    {
        $this->Parties = $parties;
        return $this;
    }
    /**
     * Get PaymentTerms value
     * @return \StructType\PaymentTerms|null
     */
    public function getPaymentTerms()
    {
        return $this->PaymentTerms;
    }
    /**
     * Set PaymentTerms value
     * @param \StructType\PaymentTerms $paymentTerms
     * @return \StructType\Invoice
     */
    public function setPaymentTerms(\StructType\PaymentTerms $paymentTerms = null)
    {
        $this->PaymentTerms = $paymentTerms;
        return $this;
    }
    /**
     * Get AllowanceCharges value
     * @return \StructType\AllowanceCharges|null
     */
    public function getAllowanceCharges()
    {
        return $this->AllowanceCharges;
    }
    /**
     * Set AllowanceCharges value
     * @param \StructType\AllowanceCharges $allowanceCharges
     * @return \StructType\Invoice
     */
    public function setAllowanceCharges(\StructType\AllowanceCharges $allowanceCharges = null)
    {
        $this->AllowanceCharges = $allowanceCharges;
        return $this;
    }
    /**
     * Get LineItems value
     * @return \StructType\LineItems|null
     */
    public function getLineItems()
    {
        return $this->LineItems;
    }
    /**
     * Set LineItems value
     * @param \StructType\LineItems $lineItems
     * @return \StructType\Invoice
     */
    public function setLineItems(\StructType\LineItems $lineItems = null)
    {
        $this->LineItems = $lineItems;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Invoice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
