<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Header_type StructType
 * @subpackage Structs
 */
class Header_type extends AbstractStructBase
{
    /**
     * The AccountNumber
     * @var int
     */
    public $AccountNumber;
    /**
     * The DistributorIdentifier
     * @var string
     */
    public $DistributorIdentifier;
    /**
     * The PurchaseOrder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 12
     * @var string
     */
    public $PurchaseOrder;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - length: 3
     * @var string
     */
    public $Code;
    /**
     * The MachineNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MachineNumber;
    /**
     * Constructor method for Header_type
     * @uses Header_type::setAccountNumber()
     * @uses Header_type::setDistributorIdentifier()
     * @uses Header_type::setPurchaseOrder()
     * @uses Header_type::setCode()
     * @uses Header_type::setMachineNumber()
     * @param int $accountNumber
     * @param string $distributorIdentifier
     * @param string $purchaseOrder
     * @param string $code
     * @param int $machineNumber
     */
    public function __construct($accountNumber = null, $distributorIdentifier = null, $purchaseOrder = null, $code = null, $machineNumber = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setDistributorIdentifier($distributorIdentifier)
            ->setPurchaseOrder($purchaseOrder)
            ->setCode($code)
            ->setMachineNumber($machineNumber);
    }
    /**
     * Get AccountNumber value
     * @return int|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param int $accountNumber
     * @return \StructType\Header_type
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: int
        if (!is_null($accountNumber) && !is_numeric($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get DistributorIdentifier value
     * @return string|null
     */
    public function getDistributorIdentifier()
    {
        return $this->DistributorIdentifier;
    }
    /**
     * Set DistributorIdentifier value
     * @uses \EnumType\DistributorIdentifier::valueIsValid()
     * @uses \EnumType\DistributorIdentifier::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $distributorIdentifier
     * @return \StructType\Header_type
     */
    public function setDistributorIdentifier($distributorIdentifier = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DistributorIdentifier::valueIsValid($distributorIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $distributorIdentifier, implode(', ', \EnumType\DistributorIdentifier::getValidValues())), __LINE__);
        }
        $this->DistributorIdentifier = $distributorIdentifier;
        return $this;
    }
    /**
     * Get PurchaseOrder value
     * @return string|null
     */
    public function getPurchaseOrder()
    {
        return $this->PurchaseOrder;
    }
    /**
     * Set PurchaseOrder value
     * @param string $purchaseOrder
     * @return \StructType\Header_type
     */
    public function setPurchaseOrder($purchaseOrder = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($purchaseOrder) && strlen($purchaseOrder) > 12) || (is_array($purchaseOrder) && count($purchaseOrder) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($purchaseOrder) ? strlen($purchaseOrder) : count($purchaseOrder)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($purchaseOrder) && !is_string($purchaseOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($purchaseOrder)), __LINE__);
        }
        $this->PurchaseOrder = $purchaseOrder;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\Header_type
     */
    public function setCode($code = null)
    {
        // validation for constraint: length
        if ((is_scalar($code) && strlen($code) !== 3) || (is_array($code) && count($code) !== 3)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get MachineNumber value
     * @return int|null
     */
    public function getMachineNumber()
    {
        return $this->MachineNumber;
    }
    /**
     * Set MachineNumber value
     * @param int $machineNumber
     * @return \StructType\Header_type
     */
    public function setMachineNumber($machineNumber = null)
    {
        // validation for constraint: int
        if (!is_null($machineNumber) && !is_numeric($machineNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($machineNumber)), __LINE__);
        }
        $this->MachineNumber = $machineNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Header_type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
