<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Header_Type StructType
 * @subpackage Structs
 */
class Header_Type_1 extends AbstractStructBase
{
    /**
     * The InvoiceCode
     * @var string
     */
    public $InvoiceCode;
    /**
     * The InvoiceType
     * Meta informations extracted from the WSDL
     * - documentation: N=NORMAL / NORMAL C=COST PLUS / COST PLUS R=PRIX FORCE / FORCED PRICE V=TAXE PROV / PROVINCIAL TAX T=FORCE B/O / FORCED B/O W=PRE BOOKING / PRE BOOKING X=ANNIVERSAIRE NON APPLICABLE MTL / ANNIVERSARY NOT APPLICABLE MTL Q=PAS FACT
     * NET,GENERER PAR CALCUL / NOT NET INVOICE GENERATED BY CALCULATION D=DROP,PAS GENERER PAR CALCUL / DROP, NOT GENERATED BY CALCULATION B=FACTURE DE B/O / B/O INVOICE I=CREDIT PAS AJUSTER INVENT,QPRA / INVENTORY CREDIT NOT AJUSTED
     * @var string
     */
    public $InvoiceType;
    /**
     * The InvoiceNumberPrefix
     * @var int
     */
    public $InvoiceNumberPrefix;
    /**
     * The InvoiceNumber
     * @var int
     */
    public $InvoiceNumber;
    /**
     * The InvoiceDate
     * @var string
     */
    public $InvoiceDate;
    /**
     * The PoNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PoNumber;
    /**
     * The PoDate
     * @var string
     */
    public $PoDate;
    /**
     * The DistributorIdentifier
     * @var string
     */
    public $DistributorIdentifier;
    /**
     * The ShipDate
     * @var string
     */
    public $ShipDate;
    /**
     * The ShippingMemoNumber
     * @var string
     */
    public $ShippingMemoNumber;
    /**
     * The GoodsAndServicesTaxAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $GoodsAndServicesTaxAmount;
    /**
     * The ProvincialTaxAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ProvincialTaxAmount;
    /**
     * The TotalAmount
     * @var float
     */
    public $TotalAmount;
    /**
     * Constructor method for Header_Type
     * @uses Header_Type_1::setInvoiceCode()
     * @uses Header_Type_1::setInvoiceType()
     * @uses Header_Type_1::setInvoiceNumberPrefix()
     * @uses Header_Type_1::setInvoiceNumber()
     * @uses Header_Type_1::setInvoiceDate()
     * @uses Header_Type_1::setPoNumber()
     * @uses Header_Type_1::setPoDate()
     * @uses Header_Type_1::setDistributorIdentifier_1()
     * @uses Header_Type_1::setShipDate()
     * @uses Header_Type_1::setShippingMemoNumber()
     * @uses Header_Type_1::setGoodsAndServicesTaxAmount()
     * @uses Header_Type_1::setProvincialTaxAmount()
     * @uses Header_Type_1::setTotalAmount()
     * @param string $invoiceCode
     * @param string $invoiceType
     * @param int $invoiceNumberPrefix
     * @param int $invoiceNumber
     * @param string $invoiceDate
     * @param string $poNumber
     * @param string $poDate
     * @param string $distributorIdentifier
     * @param string $shipDate
     * @param string $shippingMemoNumber
     * @param float $goodsAndServicesTaxAmount
     * @param float $provincialTaxAmount
     * @param float $totalAmount
     */
    public function __construct($invoiceCode = null, $invoiceType = null, $invoiceNumberPrefix = null, $invoiceNumber = null, $invoiceDate = null, $poNumber = null, $poDate = null, $distributorIdentifier = null, $shipDate = null, $shippingMemoNumber = null, $goodsAndServicesTaxAmount = null, $provincialTaxAmount = null, $totalAmount = null)
    {
        $this
            ->setInvoiceCode($invoiceCode)
            ->setInvoiceType($invoiceType)
            ->setInvoiceNumberPrefix($invoiceNumberPrefix)
            ->setInvoiceNumber($invoiceNumber)
            ->setInvoiceDate($invoiceDate)
            ->setPoNumber($poNumber)
            ->setPoDate($poDate)
            ->setDistributorIdentifier_1($distributorIdentifier)
            ->setShipDate($shipDate)
            ->setShippingMemoNumber($shippingMemoNumber)
            ->setGoodsAndServicesTaxAmount($goodsAndServicesTaxAmount)
            ->setProvincialTaxAmount($provincialTaxAmount)
            ->setTotalAmount($totalAmount);
    }
    /**
     * Get InvoiceCode value
     * @return string|null
     */
    public function getInvoiceCode()
    {
        return $this->InvoiceCode;
    }
    /**
     * Set InvoiceCode value
     * @param string $invoiceCode
     * @return \StructType\Header_Type_1
     */
    public function setInvoiceCode($invoiceCode = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceCode) && !is_string($invoiceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceCode)), __LINE__);
        }
        $this->InvoiceCode = $invoiceCode;
        return $this;
    }
    /**
     * Get InvoiceType value
     * @return string|null
     */
    public function getInvoiceType()
    {
        return $this->InvoiceType;
    }
    /**
     * Set InvoiceType value
     * @param string $invoiceType
     * @return \StructType\Header_Type_1
     */
    public function setInvoiceType($invoiceType = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceType) && !is_string($invoiceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceType)), __LINE__);
        }
        $this->InvoiceType = $invoiceType;
        return $this;
    }
    /**
     * Get InvoiceNumberPrefix value
     * @return int|null
     */
    public function getInvoiceNumberPrefix()
    {
        return $this->InvoiceNumberPrefix;
    }
    /**
     * Set InvoiceNumberPrefix value
     * @param int $invoiceNumberPrefix
     * @return \StructType\Header_Type_1
     */
    public function setInvoiceNumberPrefix($invoiceNumberPrefix = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceNumberPrefix) && !is_numeric($invoiceNumberPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($invoiceNumberPrefix)), __LINE__);
        }
        $this->InvoiceNumberPrefix = $invoiceNumberPrefix;
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * @return int|null
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }
    /**
     * Set InvoiceNumber value
     * @param int $invoiceNumber
     * @return \StructType\Header_Type_1
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceNumber) && !is_numeric($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($invoiceNumber)), __LINE__);
        }
        $this->InvoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get InvoiceDate value
     * @return string|null
     */
    public function getInvoiceDate()
    {
        return $this->InvoiceDate;
    }
    /**
     * Set InvoiceDate value
     * @param string $invoiceDate
     * @return \StructType\Header_Type_1
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceDate)), __LINE__);
        }
        $this->InvoiceDate = $invoiceDate;
        return $this;
    }
    /**
     * Get PoNumber value
     * @return string|null
     */
    public function getPoNumber()
    {
        return $this->PoNumber;
    }
    /**
     * Set PoNumber value
     * @param string $poNumber
     * @return \StructType\Header_Type_1
     */
    public function setPoNumber($poNumber = null)
    {
        // validation for constraint: string
        if (!is_null($poNumber) && !is_string($poNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($poNumber)), __LINE__);
        }
        $this->PoNumber = $poNumber;
        return $this;
    }
    /**
     * Get PoDate value
     * @return string|null
     */
    public function getPoDate()
    {
        return $this->PoDate;
    }
    /**
     * Set PoDate value
     * @param string $poDate
     * @return \StructType\Header_Type_1
     */
    public function setPoDate($poDate = null)
    {
        // validation for constraint: string
        if (!is_null($poDate) && !is_string($poDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($poDate)), __LINE__);
        }
        $this->PoDate = $poDate;
        return $this;
    }
    /**
     * Get distributorIdentifier_1 value
     * @return distributorIdentifier_1
     */
    public function getDistributorIdentifier_1()
    {
        return $this->DistributorIdentifier;
    }
    /**
     * Set DistributorIdentifier value
     * @param string $distributorIdentifier
     * @return \StructType\Header_Type_1
     */
    public function setDistributorIdentifier_1($distributorIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($distributorIdentifier) && !is_string($distributorIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distributorIdentifier)), __LINE__);
        }
        $this->DistributorIdentifier = $distributorIdentifier;
        return $this;
    }
    /**
     * Get ShipDate value
     * @return string|null
     */
    public function getShipDate()
    {
        return $this->ShipDate;
    }
    /**
     * Set ShipDate value
     * @param string $shipDate
     * @return \StructType\Header_Type_1
     */
    public function setShipDate($shipDate = null)
    {
        // validation for constraint: string
        if (!is_null($shipDate) && !is_string($shipDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipDate)), __LINE__);
        }
        $this->ShipDate = $shipDate;
        return $this;
    }
    /**
     * Get ShippingMemoNumber value
     * @return string|null
     */
    public function getShippingMemoNumber()
    {
        return $this->ShippingMemoNumber;
    }
    /**
     * Set ShippingMemoNumber value
     * @param string $shippingMemoNumber
     * @return \StructType\Header_Type_1
     */
    public function setShippingMemoNumber($shippingMemoNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shippingMemoNumber) && !is_string($shippingMemoNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shippingMemoNumber)), __LINE__);
        }
        $this->ShippingMemoNumber = $shippingMemoNumber;
        return $this;
    }
    /**
     * Get GoodsAndServicesTaxAmount value
     * @return float|null
     */
    public function getGoodsAndServicesTaxAmount()
    {
        return $this->GoodsAndServicesTaxAmount;
    }
    /**
     * Set GoodsAndServicesTaxAmount value
     * @param float $goodsAndServicesTaxAmount
     * @return \StructType\Header_Type_1
     */
    public function setGoodsAndServicesTaxAmount($goodsAndServicesTaxAmount = null)
    {
        $this->GoodsAndServicesTaxAmount = $goodsAndServicesTaxAmount;
        return $this;
    }
    /**
     * Get ProvincialTaxAmount value
     * @return float|null
     */
    public function getProvincialTaxAmount()
    {
        return $this->ProvincialTaxAmount;
    }
    /**
     * Set ProvincialTaxAmount value
     * @param float $provincialTaxAmount
     * @return \StructType\Header_Type_1
     */
    public function setProvincialTaxAmount($provincialTaxAmount = null)
    {
        $this->ProvincialTaxAmount = $provincialTaxAmount;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return float|null
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param float $totalAmount
     * @return \StructType\Header_Type_1
     */
    public function setTotalAmount($totalAmount = null)
    {
        $this->TotalAmount = $totalAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Header_Type_1
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
