<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetInvoices StructType
 * @subpackage Structs
 */
class GetInvoices extends AbstractStructBase
{
    /**
     * The Authentication
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The InvoiceInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 10
     * @var \StructType\InvoiceInformation[]
     */
    public $InvoiceInformation;
    /**
     * Constructor method for GetInvoices
     * @uses GetInvoices::setAuthentication()
     * @uses GetInvoices::setInvoiceInformation()
     * @param \StructType\Authentication $authentication
     * @param \StructType\InvoiceInformation[] $invoiceInformation
     */
    public function __construct(\StructType\Authentication $authentication = null, array $invoiceInformation = array())
    {
        $this
            ->setAuthentication($authentication)
            ->setInvoiceInformation($invoiceInformation);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication|null
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\GetInvoices
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get InvoiceInformation value
     * @return \StructType\InvoiceInformation[]|null
     */
    public function getInvoiceInformation()
    {
        return $this->InvoiceInformation;
    }
    /**
     * Set InvoiceInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceInformation[] $invoiceInformation
     * @return \StructType\GetInvoices
     */
    public function setInvoiceInformation(array $invoiceInformation = array())
    {
        foreach ($invoiceInformation as $getInvoicesInvoiceInformationItem) {
            // validation for constraint: itemType
            if (!$getInvoicesInvoiceInformationItem instanceof \StructType\InvoiceInformation) {
                throw new \InvalidArgumentException(sprintf('The InvoiceInformation property can only contain items of \StructType\InvoiceInformation, "%s" given', is_object($getInvoicesInvoiceInformationItem) ? get_class($getInvoicesInvoiceInformationItem) : gettype($getInvoicesInvoiceInformationItem)), __LINE__);
            }
        }
        $this->InvoiceInformation = $invoiceInformation;
        return $this;
    }
    /**
     * Add item to InvoiceInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceInformation $item
     * @return \StructType\GetInvoices
     */
    public function addToInvoiceInformation(\StructType\InvoiceInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvoiceInformation) {
            throw new \InvalidArgumentException(sprintf('The InvoiceInformation property can only contain items of \StructType\InvoiceInformation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InvoiceInformation[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetInvoices
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
