<?php

namespace EnumType;

/**
 * This class stands for FaultCode EnumType
 * @subpackage Enumerations
 */
class FaultCode
{
    /**
     * Constant for value 'InvalidLoginPassword'
     * @return string 'InvalidLoginPassword'
     */
    const VALUE_INVALID_LOGIN_PASSWORD = 'InvalidLoginPassword';
    /**
     * Constant for value 'InvalidRole'
     * @return string 'InvalidRole'
     */
    const VALUE_INVALID_ROLE = 'InvalidRole';
    /**
     * Constant for value 'AccountLocked'
     * @return string 'AccountLocked'
     */
    const VALUE_ACCOUNT_LOCKED = 'AccountLocked';
    /**
     * Constant for value 'PasswordExpired'
     * @return string 'PasswordExpired'
     */
    const VALUE_PASSWORD_EXPIRED = 'PasswordExpired';
    /**
     * Constant for value 'UserPwdExpired'
     * @return string 'UserPwdExpired'
     */
    const VALUE_USER_PWD_EXPIRED = 'UserPwdExpired';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INVALID_LOGIN_PASSWORD
     * @uses self::VALUE_INVALID_ROLE
     * @uses self::VALUE_ACCOUNT_LOCKED
     * @uses self::VALUE_PASSWORD_EXPIRED
     * @uses self::VALUE_USER_PWD_EXPIRED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INVALID_LOGIN_PASSWORD,
            self::VALUE_INVALID_ROLE,
            self::VALUE_ACCOUNT_LOCKED,
            self::VALUE_PASSWORD_EXPIRED,
            self::VALUE_USER_PWD_EXPIRED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
