<?php

namespace EnumType;

/**
 * This class stands for DistributorIdentifier EnumType
 * @subpackage Enumerations
 */
class DistributorIdentifier
{
    /**
     * Constant for value 'MBA'
     * @return string 'MBA'
     */
    const VALUE_MBA = 'MBA';
    /**
     * Constant for value 'DIS'
     * @return string 'DIS'
     */
    const VALUE_DIS = 'DIS';
    /**
     * Constant for value 'APS'
     * @return string 'APS'
     */
    const VALUE_APS = 'APS';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MBA
     * @uses self::VALUE_DIS
     * @uses self::VALUE_APS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MBA,
            self::VALUE_DIS,
            self::VALUE_APS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
