<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://webservices.mckesson.ca/BusinessServices/ORDERS/Service/intfOrders-service.serviceagent?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://webservices.mckesson.ca/BusinessServices/ORDERS/Service/intfOrders-service.serviceagent?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getInvoices operation/method
 */
if ($get->getInvoices(new \StructType\GetInvoices()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCatalog operation/method
 */
if ($get->getCatalog(new \StructType\CatalogueRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for All ServiceType
 */
$all = new \ServiceType\All($options);
/**
 * Sample call for AllNew operation/method
 */
if ($all->AllNew(new \StructType\InvoiceRequestAllNew()) !== false) {
    print_r($all->getResult());
} else {
    print_r($all->getLastError());
}
/**
 * Samples for Invoice ServiceType
 */
$invoice = new \ServiceType\Invoice($options);
/**
 * Sample call for invoiceByDate operation/method
 */
if ($invoice->invoiceByDate(new \StructType\InvoiceRequestByDate()) !== false) {
    print_r($invoice->getResult());
} else {
    print_r($invoice->getLastError());
}
/**
 * Samples for Upload ServiceType
 */
$upload = new \ServiceType\Upload($options);
/**
 * Sample call for UploadOrderOp operation/method
 */
if ($upload->UploadOrderOp(new \StructType\OrderInformationRequest()) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
