<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderedItem StructType
 * @subpackage Structs
 */
class OrderedItem extends AbstractStructBase
{
    /**
     * The LineItemNumber
     * @var int
     */
    public $LineItemNumber;
    /**
     * The LineItemErrorCode
     * Meta informations extracted from the WSDL
     * - documentation: A = NUMERO DE PRODUIT INEXISTANT / ITEM NOT STOCKED DO NOT RE-ORDER B = CODE UPC INEXISTANT / INVALID UPC NUMBER C = PRODUIT NON TENU PAR CETTE DIVISION / NOT CARRIED BY THE D.C. D = PRODUIT NARCOTIQUE NON PERMIS / NARCOTIC ITEM NOT
     * ALLOWED E = PRODUIT PHARMACEUTIQUE NON PERMIS / DRUGSTORE ITEM NOT ALLOWED F = PRODUIT ECLUSIF BANNIERE / RESTRICTED TO AUTHORIZED DEALERS G = COMMANDE ELECTRONIQUE REFUSEE / E.O.E NOT ALLOWED H = TAUX DE FACTURATION INEXIST / CUSTOMER OR UPG. TABLE
     * NOT FOUND I = RESTRICTION DE VENTE / PRODUIT TABAC / SALE RESTRICTION ON TOBACCO PRODUCT J = NO PERMIS TABAC DU CLIENT INEXISTANT / TOBACCO PERMIT MISSING FOR THE CUSTOMER K = NON APPROUVÉ PAR VOTRE COMITÉ D'ACHAT / ITEM IS NOT AUTHORIZED BY YOUR
     * H/O L = PRODUIT NON INCLUS DANS LE PGM DE CONFORMITÉ / ITEM NOT INCLUDED IN CONFORMITY PROGRAM
     * - minOccurs: 0
     * @var mixed
     */
    public $LineItemErrorCode;
    /**
     * The ShipmentStatus
     * @var string
     */
    public $ShipmentStatus;
    /**
     * The ItemNumber
     * @var int
     */
    public $ItemNumber;
    /**
     * The ItemDescriptionEn
     * @var string
     */
    public $ItemDescriptionEn;
    /**
     * The ItemDescriptionFr
     * @var string
     */
    public $ItemDescriptionFr;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The UnitOfMeasure
     * @var string
     */
    public $UnitOfMeasure;
    /**
     * The GTIN
     * @var int
     */
    public $GTIN;
    /**
     * The CallNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CallNumber;
    /**
     * Constructor method for OrderedItem
     * @uses OrderedItem::setLineItemNumber()
     * @uses OrderedItem::setLineItemErrorCode()
     * @uses OrderedItem::setShipmentStatus()
     * @uses OrderedItem::setItemNumber()
     * @uses OrderedItem::setItemDescriptionEn()
     * @uses OrderedItem::setItemDescriptionFr()
     * @uses OrderedItem::setQuantity()
     * @uses OrderedItem::setUnitOfMeasure()
     * @uses OrderedItem::setGTIN()
     * @uses OrderedItem::setCallNumber()
     * @param int $lineItemNumber
     * @param mixed $lineItemErrorCode
     * @param string $shipmentStatus
     * @param int $itemNumber
     * @param string $itemDescriptionEn
     * @param string $itemDescriptionFr
     * @param int $quantity
     * @param string $unitOfMeasure
     * @param int $gTIN
     * @param string $callNumber
     */
    public function __construct($lineItemNumber = null, $lineItemErrorCode = null, $shipmentStatus = null, $itemNumber = null, $itemDescriptionEn = null, $itemDescriptionFr = null, $quantity = null, $unitOfMeasure = null, $gTIN = null, $callNumber = null)
    {
        $this
            ->setLineItemNumber($lineItemNumber)
            ->setLineItemErrorCode($lineItemErrorCode)
            ->setShipmentStatus($shipmentStatus)
            ->setItemNumber($itemNumber)
            ->setItemDescriptionEn($itemDescriptionEn)
            ->setItemDescriptionFr($itemDescriptionFr)
            ->setQuantity($quantity)
            ->setUnitOfMeasure($unitOfMeasure)
            ->setGTIN($gTIN)
            ->setCallNumber($callNumber);
    }
    /**
     * Get LineItemNumber value
     * @return int|null
     */
    public function getLineItemNumber()
    {
        return $this->LineItemNumber;
    }
    /**
     * Set LineItemNumber value
     * @param int $lineItemNumber
     * @return \StructType\OrderedItem
     */
    public function setLineItemNumber($lineItemNumber = null)
    {
        // validation for constraint: int
        if (!is_null($lineItemNumber) && !is_numeric($lineItemNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lineItemNumber)), __LINE__);
        }
        $this->LineItemNumber = $lineItemNumber;
        return $this;
    }
    /**
     * Get LineItemErrorCode value
     * @return mixed|null
     */
    public function getLineItemErrorCode()
    {
        return $this->LineItemErrorCode;
    }
    /**
     * Set LineItemErrorCode value
     * @param mixed $lineItemErrorCode
     * @return \StructType\OrderedItem
     */
    public function setLineItemErrorCode($lineItemErrorCode = null)
    {
        $this->LineItemErrorCode = $lineItemErrorCode;
        return $this;
    }
    /**
     * Get ShipmentStatus value
     * @return string|null
     */
    public function getShipmentStatus()
    {
        return $this->ShipmentStatus;
    }
    /**
     * Set ShipmentStatus value
     * @param string $shipmentStatus
     * @return \StructType\OrderedItem
     */
    public function setShipmentStatus($shipmentStatus = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentStatus) && !is_string($shipmentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipmentStatus)), __LINE__);
        }
        $this->ShipmentStatus = $shipmentStatus;
        return $this;
    }
    /**
     * Get ItemNumber value
     * @return int|null
     */
    public function getItemNumber()
    {
        return $this->ItemNumber;
    }
    /**
     * Set ItemNumber value
     * @param int $itemNumber
     * @return \StructType\OrderedItem
     */
    public function setItemNumber($itemNumber = null)
    {
        // validation for constraint: int
        if (!is_null($itemNumber) && !is_numeric($itemNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($itemNumber)), __LINE__);
        }
        $this->ItemNumber = $itemNumber;
        return $this;
    }
    /**
     * Get ItemDescriptionEn value
     * @return string|null
     */
    public function getItemDescriptionEn()
    {
        return $this->ItemDescriptionEn;
    }
    /**
     * Set ItemDescriptionEn value
     * @param string $itemDescriptionEn
     * @return \StructType\OrderedItem
     */
    public function setItemDescriptionEn($itemDescriptionEn = null)
    {
        // validation for constraint: string
        if (!is_null($itemDescriptionEn) && !is_string($itemDescriptionEn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemDescriptionEn)), __LINE__);
        }
        $this->ItemDescriptionEn = $itemDescriptionEn;
        return $this;
    }
    /**
     * Get ItemDescriptionFr value
     * @return string|null
     */
    public function getItemDescriptionFr()
    {
        return $this->ItemDescriptionFr;
    }
    /**
     * Set ItemDescriptionFr value
     * @param string $itemDescriptionFr
     * @return \StructType\OrderedItem
     */
    public function setItemDescriptionFr($itemDescriptionFr = null)
    {
        // validation for constraint: string
        if (!is_null($itemDescriptionFr) && !is_string($itemDescriptionFr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemDescriptionFr)), __LINE__);
        }
        $this->ItemDescriptionFr = $itemDescriptionFr;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\OrderedItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get UnitOfMeasure value
     * @return string|null
     */
    public function getUnitOfMeasure()
    {
        return $this->UnitOfMeasure;
    }
    /**
     * Set UnitOfMeasure value
     * @param string $unitOfMeasure
     * @return \StructType\OrderedItem
     */
    public function setUnitOfMeasure($unitOfMeasure = null)
    {
        // validation for constraint: string
        if (!is_null($unitOfMeasure) && !is_string($unitOfMeasure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitOfMeasure)), __LINE__);
        }
        $this->UnitOfMeasure = $unitOfMeasure;
        return $this;
    }
    /**
     * Get GTIN value
     * @return int|null
     */
    public function getGTIN()
    {
        return $this->GTIN;
    }
    /**
     * Set GTIN value
     * @param int $gTIN
     * @return \StructType\OrderedItem
     */
    public function setGTIN($gTIN = null)
    {
        // validation for constraint: int
        if (!is_null($gTIN) && !is_numeric($gTIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($gTIN)), __LINE__);
        }
        $this->GTIN = $gTIN;
        return $this;
    }
    /**
     * Get CallNumber value
     * @return string|null
     */
    public function getCallNumber()
    {
        return $this->CallNumber;
    }
    /**
     * Set CallNumber value
     * @param string $callNumber
     * @return \StructType\OrderedItem
     */
    public function setCallNumber($callNumber = null)
    {
        // validation for constraint: string
        if (!is_null($callNumber) && !is_string($callNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callNumber)), __LINE__);
        }
        $this->CallNumber = $callNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderedItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
