<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListInvoice StructType
 * @subpackage Structs
 */
class ListInvoice extends AbstractStructBase
{
    /**
     * The Invoice
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ns0:Invoice
     * @var \StructType\Invoice[]
     */
    public $Invoice;
    /**
     * Constructor method for ListInvoice
     * @uses ListInvoice::setInvoice()
     * @param \StructType\Invoice[] $invoice
     */
    public function __construct(array $invoice = array())
    {
        $this
            ->setInvoice($invoice);
    }
    /**
     * Get Invoice value
     * @return \StructType\Invoice[]|null
     */
    public function getInvoice()
    {
        return $this->Invoice;
    }
    /**
     * Set Invoice value
     * @throws \InvalidArgumentException
     * @param \StructType\Invoice[] $invoice
     * @return \StructType\ListInvoice
     */
    public function setInvoice(array $invoice = array())
    {
        foreach ($invoice as $listInvoiceInvoiceItem) {
            // validation for constraint: itemType
            if (!$listInvoiceInvoiceItem instanceof \StructType\Invoice) {
                throw new \InvalidArgumentException(sprintf('The Invoice property can only contain items of \StructType\Invoice, "%s" given', is_object($listInvoiceInvoiceItem) ? get_class($listInvoiceInvoiceItem) : gettype($listInvoiceInvoiceItem)), __LINE__);
            }
        }
        $this->Invoice = $invoice;
        return $this;
    }
    /**
     * Add item to Invoice value
     * @throws \InvalidArgumentException
     * @param \StructType\Invoice $item
     * @return \StructType\ListInvoice
     */
    public function addToInvoice(\StructType\Invoice $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Invoice) {
            throw new \InvalidArgumentException(sprintf('The Invoice property can only contain items of \StructType\Invoice, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Invoice[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ListInvoice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
