<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for All ServiceType
 * @subpackage Services
 */
class All extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AllNew
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InvoiceRequestAllNew $invoiceRequestAllNew
     * @return \StructType\InvoiceResponse|bool
     */
    public function AllNew(\StructType\InvoiceRequestAllNew $invoiceRequestAllNew)
    {
        try {
            $this->setResult(self::getSoapClient()->AllNew($invoiceRequestAllNew));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\InvoiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
