<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Lookup ServiceType
 * @subpackage Services
 */
class Lookup extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named LookupItem
     * Meta informations extracted from the WSDL
     * - documentation: Returns XML item information from SearchString.<br>To view the schema of the input/return values of this function <a href="Schemas/LookupItem.xsl">Click Here</a> | Returns XML item information from SearchString.<br>To view the schema
     * of the input/return values of this function <a href="Schemas/LookupItem.xsl">Click Here</a> | Returns XML item information from SearchString.<br>To view the schema of the input/return values of this function <a href="Schemas/LookupItem.xsl">Click
     * Here</a>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LookupItem $parameters
     * @return \StructType\LookupItemResponse|bool
     */
    public function LookupItem(\StructType\LookupItem $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->LookupItem($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\LookupItemResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
