<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Onhand ServiceType
 * @subpackage Services
 */
class Onhand extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named OnhandUpdateDS
     * Meta informations extracted from the WSDL
     * - documentation: Returns DATASET List of items, catalog price, customer price and quantity onhand. (Fields: I=ItemNumber, P=Catalog Price, Q=Current Quantity, C=Customer Price).<br>To view the schema of the input/return values of this function <a
     * href="Schemas/OnhandUpdate.xsl">Click Here</a> | Returns DATASET List of items, catalog price, customer price and quantity onhand. (Fields: I=ItemNumber, P=Catalog Price, Q=Current Quantity, C=Customer Price).<br>To view the schema of the
     * input/return values of this function <a href="Schemas/OnhandUpdate.xsl">Click Here</a> | Returns DATASET List of items, catalog price, customer price and quantity onhand. (Fields: I=ItemNumber, P=Catalog Price, Q=Current Quantity, C=Customer
     * Price).<br>To view the schema of the input/return values of this function <a href="Schemas/OnhandUpdate.xsl">Click Here</a>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OnhandUpdateDS $parameters
     * @return \StructType\OnhandUpdateDSResponse|bool
     */
    public function OnhandUpdateDS(\StructType\OnhandUpdateDS $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->OnhandUpdateDS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OnhandUpdate
     * Meta informations extracted from the WSDL
     * - documentation: Returns XML List of items, current price, customer price and quantity onhand. (Fields: I=ItemNumber, P=Catalog Price, Q=Current Quantity, C=Customer Price).<br>To view the schema of the input/return values of this function <a
     * href="Schemas/OnhandUpdate.xsl">Click Here</a> | Returns XML List of items, current price, customer price and quantity onhand. (Fields: I=ItemNumber, P=Catalog Price, Q=Current Quantity, C=Customer Price).<br>To view the schema of the input/return
     * values of this function <a href="Schemas/OnhandUpdate.xsl">Click Here</a> | Returns XML List of items, current price, customer price and quantity onhand. (Fields: I=ItemNumber, P=Catalog Price, Q=Current Quantity, C=Customer Price).<br>To view the
     * schema of the input/return values of this function <a href="Schemas/OnhandUpdate.xsl">Click Here</a>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OnhandUpdate $parameters
     * @return \StructType\OnhandUpdateResponse|bool
     */
    public function OnhandUpdate(\StructType\OnhandUpdate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->OnhandUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OnhandUpdateCSV
     * Meta informations extracted from the WSDL
     * - documentation: Returns CSV List of items, customer price and quantity onhand. (Fields: I=ItemNumber, Q=Current Quantity, C=Customer Price in the form 00000,000,0.00 seperated by control-linefeed). | Returns CSV List of items, customer price and
     * quantity onhand. (Fields: I=ItemNumber, Q=Current Quantity, C=Customer Price in the form 00000,000,0.00 seperated by control-linefeed). | Returns CSV List of items, customer price and quantity onhand. (Fields: I=ItemNumber, Q=Current Quantity,
     * C=Customer Price in the form 00000,000,0.00 seperated by control-linefeed).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OnhandUpdateCSV $parameters
     * @return \StructType\OnhandUpdateCSVResponse|bool
     */
    public function OnhandUpdateCSV(\StructType\OnhandUpdateCSV $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->OnhandUpdateCSV($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OnhandUpdatebyCSV
     * Meta informations extracted from the WSDL
     * - documentation: Returns XML List of items, customer price and quantity onhand. (Fields: I=ItemNumber, Q=Current Quantity, C=Customer Price) for all item numbers in the CSVItems variable. | Returns XML List of items, customer price and quantity
     * onhand. (Fields: I=ItemNumber, Q=Current Quantity, C=Customer Price) for all item numbers in the CSVItems variable. | Returns XML List of items, customer price and quantity onhand. (Fields: I=ItemNumber, Q=Current Quantity, C=Customer Price) for all
     * item numbers in the CSVItems variable.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OnhandUpdatebyCSV $parameters
     * @return \StructType\OnhandUpdatebyCSVResponse|bool
     */
    public function OnhandUpdatebyCSV(\StructType\OnhandUpdatebyCSV $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->OnhandUpdatebyCSV($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OnhandInquiry
     * Meta informations extracted from the WSDL
     * - documentation: Returns XML List of items, current price, customer price and quantity onhand for a single Item. (Fields: I=ItemNumber, P=Catalog Price, Q=Current Quantity, C=Customer Price,U=UPC).<br>To view the schema of the input/return values of
     * this function <a href="Schemas/OnhandUpdate.xsl">Click Here</a> | Returns XML List of items, current price, customer price and quantity onhand for a single Item. (Fields: I=ItemNumber, P=Catalog Price, Q=Current Quantity, C=Customer
     * Price,U=UPC).<br>To view the schema of the input/return values of this function <a href="Schemas/OnhandUpdate.xsl">Click Here</a> | Returns XML List of items, current price, customer price and quantity onhand for a single Item. (Fields: I=ItemNumber,
     * P=Catalog Price, Q=Current Quantity, C=Customer Price,U=UPC).<br>To view the schema of the input/return values of this function <a href="Schemas/OnhandUpdate.xsl">Click Here</a>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OnhandInquiry $parameters
     * @return \StructType\OnhandInquiryResponse|bool
     */
    public function OnhandInquiry(\StructType\OnhandInquiry $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->OnhandInquiry($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OnhandInquiryResponse|\StructType\OnhandUpdatebyCSVResponse|\StructType\OnhandUpdateCSVResponse|\StructType\OnhandUpdateDSResponse|\StructType\OnhandUpdateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
