<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Department ServiceType
 * @subpackage Services
 */
class Department extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DepartmentUpdate
     * Meta informations extracted from the WSDL
     * - documentation: Returns XML of Category Department descriptions.<br>To view the schema of the input/return values of this function <a href="Schemas/DepartmentUpdate.xsl">Click Here</a> | Returns XML of Category Department descriptions.<br>To view
     * the schema of the input/return values of this function <a href="Schemas/DepartmentUpdate.xsl">Click Here</a> | Returns XML of Category Department descriptions.<br>To view the schema of the input/return values of this function <a
     * href="Schemas/DepartmentUpdate.xsl">Click Here</a>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DepartmentUpdate $parameters
     * @return \StructType\DepartmentUpdateResponse|bool
     */
    public function DepartmentUpdate(\StructType\DepartmentUpdate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DepartmentUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DepartmentUpdateDS
     * Meta informations extracted from the WSDL
     * - documentation: Returns DATASET of Category Department descriptions.<br>To view the schema of the input/return values of this function <a href="Schemas/DepartmentUpdate.xsl">Click Here</a> | Returns DATASET of Category Department descriptions.<br>To
     * view the schema of the input/return values of this function <a href="Schemas/DepartmentUpdate.xsl">Click Here</a> | Returns DATASET of Category Department descriptions.<br>To view the schema of the input/return values of this function <a
     * href="Schemas/DepartmentUpdate.xsl">Click Here</a>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DepartmentUpdateDS $parameters
     * @return \StructType\DepartmentUpdateDSResponse|bool
     */
    public function DepartmentUpdateDS(\StructType\DepartmentUpdateDS $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DepartmentUpdateDS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DepartmentUpdateDSResponse|\StructType\DepartmentUpdateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
