<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Full ServiceType
 * @subpackage Services
 */
class Full extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named FullTextSearch
     * Meta informations extracted from the WSDL
     * - documentation: Returns XML List of items .<br>To view the schema of the input/return values of this function <a href="schemas/FullTextSearch.xsl">Click Here</a> | Returns XML List of items .<br>To view the schema of the input/return values of this
     * function <a href="schemas/FullTextSearch.xsl">Click Here</a> | Returns XML List of items .<br>To view the schema of the input/return values of this function <a href="schemas/FullTextSearch.xsl">Click Here</a>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FullTextSearch $parameters
     * @return \StructType\FullTextSearchResponse|bool
     */
    public function FullTextSearch(\StructType\FullTextSearch $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->FullTextSearch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FullTextSearchHints
     * Meta informations extracted from the WSDL
     * - documentation: Returns XML List of related search terms. | Returns XML List of related search terms. | Returns XML List of related search terms.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FullTextSearchHints $parameters
     * @return \StructType\FullTextSearchHintsResponse|bool
     */
    public function FullTextSearchHints(\StructType\FullTextSearchHints $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->FullTextSearchHints($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\FullTextSearchHintsResponse|\StructType\FullTextSearchResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
