<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webservices.theshootingwarehouse.com/smart/inventory.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webservices.theshootingwarehouse.com/smart/inventory.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Active ServiceType
 */
$active = new \ServiceType\Active($options);
/**
 * Sample call for ActiveItemCount operation/method
 */
if ($active->ActiveItemCount(new \StructType\ActiveItemCount()) !== false) {
    print_r($active->getResult());
} else {
    print_r($active->getLastError());
}
/**
 * Samples for Brand ServiceType
 */
$brand = new \ServiceType\Brand($options);
/**
 * Sample call for BrandUpdate operation/method
 */
if ($brand->BrandUpdate(new \StructType\BrandUpdate()) !== false) {
    print_r($brand->getResult());
} else {
    print_r($brand->getLastError());
}
/**
 * Sample call for BrandUpdateDS operation/method
 */
if ($brand->BrandUpdateDS(new \StructType\BrandUpdateDS()) !== false) {
    print_r($brand->getResult());
} else {
    print_r($brand->getLastError());
}
/**
 * Samples for Incremental ServiceType
 */
$incremental = new \ServiceType\Incremental($options);
/**
 * Sample call for IncrementalOnhandUpdateDS operation/method
 */
if ($incremental->IncrementalOnhandUpdateDS(new \StructType\IncrementalOnhandUpdateDS()) !== false) {
    print_r($incremental->getResult());
} else {
    print_r($incremental->getLastError());
}
/**
 * Sample call for IncrementalOnhandUpdate operation/method
 */
if ($incremental->IncrementalOnhandUpdate(new \StructType\IncrementalOnhandUpdate()) !== false) {
    print_r($incremental->getResult());
} else {
    print_r($incremental->getLastError());
}
/**
 * Samples for Onhand ServiceType
 */
$onhand = new \ServiceType\Onhand($options);
/**
 * Sample call for OnhandUpdateDS operation/method
 */
if ($onhand->OnhandUpdateDS(new \StructType\OnhandUpdateDS()) !== false) {
    print_r($onhand->getResult());
} else {
    print_r($onhand->getLastError());
}
/**
 * Sample call for OnhandUpdate operation/method
 */
if ($onhand->OnhandUpdate(new \StructType\OnhandUpdate()) !== false) {
    print_r($onhand->getResult());
} else {
    print_r($onhand->getLastError());
}
/**
 * Sample call for OnhandUpdateCSV operation/method
 */
if ($onhand->OnhandUpdateCSV(new \StructType\OnhandUpdateCSV()) !== false) {
    print_r($onhand->getResult());
} else {
    print_r($onhand->getLastError());
}
/**
 * Sample call for OnhandUpdatebyCSV operation/method
 */
if ($onhand->OnhandUpdatebyCSV(new \StructType\OnhandUpdatebyCSV()) !== false) {
    print_r($onhand->getResult());
} else {
    print_r($onhand->getLastError());
}
/**
 * Sample call for OnhandInquiry operation/method
 */
if ($onhand->OnhandInquiry(new \StructType\OnhandInquiry()) !== false) {
    print_r($onhand->getResult());
} else {
    print_r($onhand->getLastError());
}
/**
 * Samples for Category ServiceType
 */
$category = new \ServiceType\Category($options);
/**
 * Sample call for CategoryUpdateDS operation/method
 */
if ($category->CategoryUpdateDS(new \StructType\CategoryUpdateDS()) !== false) {
    print_r($category->getResult());
} else {
    print_r($category->getLastError());
}
/**
 * Sample call for CategoryUpdate operation/method
 */
if ($category->CategoryUpdate(new \StructType\CategoryUpdate()) !== false) {
    print_r($category->getResult());
} else {
    print_r($category->getLastError());
}
/**
 * Sample call for CategorySearchFieldsDS operation/method
 */
if ($category->CategorySearchFieldsDS(new \StructType\CategorySearchFieldsDS()) !== false) {
    print_r($category->getResult());
} else {
    print_r($category->getLastError());
}
/**
 * Sample call for CategorySearchFields operation/method
 */
if ($category->CategorySearchFields(new \StructType\CategorySearchFields()) !== false) {
    print_r($category->getResult());
} else {
    print_r($category->getLastError());
}
/**
 * Samples for Department ServiceType
 */
$department = new \ServiceType\Department($options);
/**
 * Sample call for DepartmentUpdate operation/method
 */
if ($department->DepartmentUpdate(new \StructType\DepartmentUpdate()) !== false) {
    print_r($department->getResult());
} else {
    print_r($department->getLastError());
}
/**
 * Sample call for DepartmentUpdateDS operation/method
 */
if ($department->DepartmentUpdateDS(new \StructType\DepartmentUpdateDS()) !== false) {
    print_r($department->getResult());
} else {
    print_r($department->getLastError());
}
/**
 * Samples for Lookup ServiceType
 */
$lookup = new \ServiceType\Lookup($options);
/**
 * Sample call for LookupItem operation/method
 */
if ($lookup->LookupItem(new \StructType\LookupItem()) !== false) {
    print_r($lookup->getResult());
} else {
    print_r($lookup->getLastError());
}
/**
 * Samples for Manufacturer ServiceType
 */
$manufacturer = new \ServiceType\Manufacturer($options);
/**
 * Sample call for ManufacturerCategoriesDS operation/method
 */
if ($manufacturer->ManufacturerCategoriesDS(new \StructType\ManufacturerCategoriesDS()) !== false) {
    print_r($manufacturer->getResult());
} else {
    print_r($manufacturer->getLastError());
}
/**
 * Sample call for ManufacturerCategories operation/method
 */
if ($manufacturer->ManufacturerCategories(new \StructType\ManufacturerCategories()) !== false) {
    print_r($manufacturer->getResult());
} else {
    print_r($manufacturer->getLastError());
}
/**
 * Sample call for ManufacturerUpdateDS operation/method
 */
if ($manufacturer->ManufacturerUpdateDS(new \StructType\ManufacturerUpdateDS()) !== false) {
    print_r($manufacturer->getResult());
} else {
    print_r($manufacturer->getLastError());
}
/**
 * Sample call for ManufacturerUpdate operation/method
 */
if ($manufacturer->ManufacturerUpdate(new \StructType\ManufacturerUpdate()) !== false) {
    print_r($manufacturer->getResult());
} else {
    print_r($manufacturer->getLastError());
}
/**
 * Samples for Daily ServiceType
 */
$daily = new \ServiceType\Daily($options);
/**
 * Sample call for DailyItemUpdateDS operation/method
 */
if ($daily->DailyItemUpdateDS(new \StructType\DailyItemUpdateDS()) !== false) {
    print_r($daily->getResult());
} else {
    print_r($daily->getLastError());
}
/**
 * Sample call for DailyItemUpdate operation/method
 */
if ($daily->DailyItemUpdate(new \StructType\DailyItemUpdate()) !== false) {
    print_r($daily->getResult());
} else {
    print_r($daily->getLastError());
}
/**
 * Sample call for DailyItemCount operation/method
 */
if ($daily->DailyItemCount(new \StructType\DailyItemCount()) !== false) {
    print_r($daily->getResult());
} else {
    print_r($daily->getLastError());
}
/**
 * Samples for Scan ServiceType
 */
$scan = new \ServiceType\Scan($options);
/**
 * Sample call for ScanNameUpdateDS operation/method
 */
if ($scan->ScanNameUpdateDS(new \StructType\ScanNameUpdateDS()) !== false) {
    print_r($scan->getResult());
} else {
    print_r($scan->getLastError());
}
/**
 * Sample call for ScanNameUpdate operation/method
 */
if ($scan->ScanNameUpdate(new \StructType\ScanNameUpdate()) !== false) {
    print_r($scan->getResult());
} else {
    print_r($scan->getLastError());
}
/**
 * Samples for Full ServiceType
 */
$full = new \ServiceType\Full($options);
/**
 * Sample call for FullTextSearch operation/method
 */
if ($full->FullTextSearch(new \StructType\FullTextSearch()) !== false) {
    print_r($full->getResult());
} else {
    print_r($full->getLastError());
}
/**
 * Sample call for FullTextSearchHints operation/method
 */
if ($full->FullTextSearchHints(new \StructType\FullTextSearchHints()) !== false) {
    print_r($full->getResult());
} else {
    print_r($full->getLastError());
}
/**
 * Samples for List ServiceType
 */
$list = new \ServiceType\_List($options);
/**
 * Sample call for ListNewTextDS operation/method
 */
if ($list->ListNewTextDS(new \StructType\ListNewTextDS()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListNewText operation/method
 */
if ($list->ListNewText(new \StructType\ListNewText()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetTextDS operation/method
 */
if ($get->GetTextDS(new \StructType\GetTextDS()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetText operation/method
 */
if ($get->GetText(new \StructType\GetText()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
