<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Incremental ServiceType
 * @subpackage Services
 */
class Incremental extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named IncrementalOnhandUpdateDS
     * Meta informations extracted from the WSDL
     * - documentation: Returns DATASET list of items, catalog price, customer price and quantity onhand where onhand has changed since parameter: SinceDateTime.<br> (Service returns <SERVERTIME> node which can be passed back in as SinceDateTime on
     * subsequent requests - format is YYYY-MM-DDTHH:mm:ss.mss-HH:00) (Fields: I=ItemNumber, P=Catalog Price, Q=Current Quantity, C=Customer Price).<br>To view the schema of the input/return values of this function <a
     * href="Schemas/OnhandIncrementalUpdate.xsl">Click Here</a> | Returns DATASET list of items, catalog price, customer price and quantity onhand where onhand has changed since parameter: SinceDateTime.<br> (Service returns <SERVERTIME> node which can be
     * passed back in as SinceDateTime on subsequent requests - format is YYYY-MM-DDTHH:mm:ss.mss-HH:00) (Fields: I=ItemNumber, P=Catalog Price, Q=Current Quantity, C=Customer Price).<br>To view the schema of the input/return values of this function <a
     * href="Schemas/OnhandIncrementalUpdate.xsl">Click Here</a> | Returns DATASET list of items, catalog price, customer price and quantity onhand where onhand has changed since parameter: SinceDateTime.<br> (Service returns <SERVERTIME> node which can be
     * passed back in as SinceDateTime on subsequent requests - format is YYYY-MM-DDTHH:mm:ss.mss-HH:00) (Fields: I=ItemNumber, P=Catalog Price, Q=Current Quantity, C=Customer Price).<br>To view the schema of the input/return values of this function <a
     * href="Schemas/OnhandIncrementalUpdate.xsl">Click Here</a>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IncrementalOnhandUpdateDS $parameters
     * @return \StructType\IncrementalOnhandUpdateDSResponse|bool
     */
    public function IncrementalOnhandUpdateDS(\StructType\IncrementalOnhandUpdateDS $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->IncrementalOnhandUpdateDS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IncrementalOnhandUpdate
     * Meta informations extracted from the WSDL
     * - documentation: Returns XML list of items, catalog price, customer price and quantity onhand where onhand has changed since parameter: SinceDateTime.<br> (Service returns <SERVERTIME> node which can be passed back in as SinceDateTime on subsequent
     * requests - format is YYYY-MM-DDTHH:mm:ss.mss-HH:00) (Fields: I=ItemNumber, P=Catalog Price, Q=Current Quantity, C=Customer Price).<br>To view the schema of the input/return values of this function <a href="Schemas/OnhandIncrementalUpdate.xsl">Click
     * Here</a> | Returns XML list of items, catalog price, customer price and quantity onhand where onhand has changed since parameter: SinceDateTime.<br> (Service returns <SERVERTIME> node which can be passed back in as SinceDateTime on subsequent
     * requests - format is YYYY-MM-DDTHH:mm:ss.mss-HH:00) (Fields: I=ItemNumber, P=Catalog Price, Q=Current Quantity, C=Customer Price).<br>To view the schema of the input/return values of this function <a href="Schemas/OnhandIncrementalUpdate.xsl">Click
     * Here</a> | Returns XML list of items, catalog price, customer price and quantity onhand where onhand has changed since parameter: SinceDateTime.<br> (Service returns <SERVERTIME> node which can be passed back in as SinceDateTime on subsequent
     * requests - format is YYYY-MM-DDTHH:mm:ss.mss-HH:00) (Fields: I=ItemNumber, P=Catalog Price, Q=Current Quantity, C=Customer Price).<br>To view the schema of the input/return values of this function <a href="Schemas/OnhandIncrementalUpdate.xsl">Click
     * Here</a>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IncrementalOnhandUpdate $parameters
     * @return \StructType\IncrementalOnhandUpdateResponse|bool
     */
    public function IncrementalOnhandUpdate(\StructType\IncrementalOnhandUpdate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->IncrementalOnhandUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IncrementalOnhandUpdateDSResponse|\StructType\IncrementalOnhandUpdateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
