<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IncrementalOnhandUpdate StructType
 * @subpackage Structs
 */
class IncrementalOnhandUpdate extends AbstractStructBase
{
    /**
     * The CustomerNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerNumber;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The SinceDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SinceDateTime;
    /**
     * The Source
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Source;
    /**
     * Constructor method for IncrementalOnhandUpdate
     * @uses IncrementalOnhandUpdate::setCustomerNumber()
     * @uses IncrementalOnhandUpdate::setUserName()
     * @uses IncrementalOnhandUpdate::setPassword()
     * @uses IncrementalOnhandUpdate::setSinceDateTime()
     * @uses IncrementalOnhandUpdate::setSource()
     * @param string $customerNumber
     * @param string $userName
     * @param string $password
     * @param string $sinceDateTime
     * @param string $source
     */
    public function __construct($customerNumber = null, $userName = null, $password = null, $sinceDateTime = null, $source = null)
    {
        $this
            ->setCustomerNumber($customerNumber)
            ->setUserName($userName)
            ->setPassword($password)
            ->setSinceDateTime($sinceDateTime)
            ->setSource($source);
    }
    /**
     * Get CustomerNumber value
     * @return string|null
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }
    /**
     * Set CustomerNumber value
     * @param string $customerNumber
     * @return \StructType\IncrementalOnhandUpdate
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customerNumber) && !is_string($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerNumber, true), gettype($customerNumber)), __LINE__);
        }
        $this->CustomerNumber = $customerNumber;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\IncrementalOnhandUpdate
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\IncrementalOnhandUpdate
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get SinceDateTime value
     * @return string|null
     */
    public function getSinceDateTime()
    {
        return $this->SinceDateTime;
    }
    /**
     * Set SinceDateTime value
     * @param string $sinceDateTime
     * @return \StructType\IncrementalOnhandUpdate
     */
    public function setSinceDateTime($sinceDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($sinceDateTime) && !is_string($sinceDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sinceDateTime, true), gettype($sinceDateTime)), __LINE__);
        }
        $this->SinceDateTime = $sinceDateTime;
        return $this;
    }
    /**
     * Get Source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param string $source
     * @return \StructType\IncrementalOnhandUpdate
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        $this->Source = $source;
        return $this;
    }
}
