<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Bulk ServiceType
 * @subpackage Services
 */
class Bulk extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named BulkPricingUpdateDS
     * Meta information extracted from the WSDL
     * - documentation: Returns Dataset of Items with bulk quantity (BULKQTY) and pricing (BULKPRC). Input 0 for item for all items. | Returns Dataset of Items with bulk quantity (BULKQTY) and pricing (BULKPRC). Input 0 for item for all items. | Returns
     * Dataset of Items with bulk quantity (BULKQTY) and pricing (BULKPRC). Input 0 for item for all items.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BulkPricingUpdateDS $parameters
     * @return \StructType\BulkPricingUpdateDSResponse|bool
     */
    public function BulkPricingUpdateDS(\StructType\BulkPricingUpdateDS $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->BulkPricingUpdateDS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named BulkPricingUpdate
     * Meta information extracted from the WSDL
     * - documentation: Returns XML List of Items with bulk quantity (BULKQTY) and pricing (BULKPRC). Input 0 for item for all items. | Returns XML List of Items with bulk quantity (BULKQTY) and pricing (BULKPRC). Input 0 for item for all items. | Returns
     * XML List of Items with bulk quantity (BULKQTY) and pricing (BULKPRC). Input 0 for item for all items.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BulkPricingUpdate $parameters
     * @return \StructType\BulkPricingUpdateResponse|bool
     */
    public function BulkPricingUpdate(\StructType\BulkPricingUpdate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->BulkPricingUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\BulkPricingUpdateDSResponse|\StructType\BulkPricingUpdateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
