<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DailyItemUpdate StructType
 * @subpackage Structs
 */
class DailyItemUpdate extends AbstractStructBase
{
    /**
     * The LastItem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LastItem;
    /**
     * The CustomerNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerNumber;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The LastUpdate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastUpdate;
    /**
     * The Source
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Source;
    /**
     * Constructor method for DailyItemUpdate
     * @uses DailyItemUpdate::setLastItem()
     * @uses DailyItemUpdate::setCustomerNumber()
     * @uses DailyItemUpdate::setUserName()
     * @uses DailyItemUpdate::setPassword()
     * @uses DailyItemUpdate::setLastUpdate()
     * @uses DailyItemUpdate::setSource()
     * @param int $lastItem
     * @param string $customerNumber
     * @param string $userName
     * @param string $password
     * @param string $lastUpdate
     * @param string $source
     */
    public function __construct($lastItem = null, $customerNumber = null, $userName = null, $password = null, $lastUpdate = null, $source = null)
    {
        $this
            ->setLastItem($lastItem)
            ->setCustomerNumber($customerNumber)
            ->setUserName($userName)
            ->setPassword($password)
            ->setLastUpdate($lastUpdate)
            ->setSource($source);
    }
    /**
     * Get LastItem value
     * @return int
     */
    public function getLastItem()
    {
        return $this->LastItem;
    }
    /**
     * Set LastItem value
     * @param int $lastItem
     * @return \StructType\DailyItemUpdate
     */
    public function setLastItem($lastItem = null)
    {
        // validation for constraint: int
        if (!is_null($lastItem) && !(is_int($lastItem) || ctype_digit($lastItem))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lastItem, true), gettype($lastItem)), __LINE__);
        }
        $this->LastItem = $lastItem;
        return $this;
    }
    /**
     * Get CustomerNumber value
     * @return string|null
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }
    /**
     * Set CustomerNumber value
     * @param string $customerNumber
     * @return \StructType\DailyItemUpdate
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customerNumber) && !is_string($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerNumber, true), gettype($customerNumber)), __LINE__);
        }
        $this->CustomerNumber = $customerNumber;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\DailyItemUpdate
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\DailyItemUpdate
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get LastUpdate value
     * @return string|null
     */
    public function getLastUpdate()
    {
        return $this->LastUpdate;
    }
    /**
     * Set LastUpdate value
     * @param string $lastUpdate
     * @return \StructType\DailyItemUpdate
     */
    public function setLastUpdate($lastUpdate = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdate) && !is_string($lastUpdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdate, true), gettype($lastUpdate)), __LINE__);
        }
        $this->LastUpdate = $lastUpdate;
        return $this;
    }
    /**
     * Get Source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param string $source
     * @return \StructType\DailyItemUpdate
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        $this->Source = $source;
        return $this;
    }
}
