<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Active ServiceType
 * @subpackage Services
 */
class Active extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ActiveItemCount
     * Meta information extracted from the WSDL
     * - documentation: Returns the active item count | Returns the active item count | Returns the active item count
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActiveItemCount $parameters
     * @return \StructType\ActiveItemCountResponse|bool
     */
    public function ActiveItemCount(\StructType\ActiveItemCount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActiveItemCount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ActiveItemCountResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
