<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for On ServiceType
 * @subpackage Services
 */
class On extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named OnHandUpdateExtended
     * Meta information extracted from the WSDL
     * - documentation: Returns XML of OnHand Quantities with extra fields. (Fields: I=ItemNumber, P=Catalog Price, Q=Current Quantity, C=Customer Price, M=Mfg Item Number, U=UPC) | Returns XML of OnHand Quantities with extra fields. (Fields: I=ItemNumber,
     * P=Catalog Price, Q=Current Quantity, C=Customer Price, M=Mfg Item Number, U=UPC) | Returns XML of OnHand Quantities with extra fields. (Fields: I=ItemNumber, P=Catalog Price, Q=Current Quantity, C=Customer Price, M=Mfg Item Number, U=UPC)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OnHandUpdateExtended $parameters
     * @return \StructType\OnHandUpdateExtendedResponse|bool
     */
    public function OnHandUpdateExtended(\StructType\OnHandUpdateExtended $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OnHandUpdateExtended($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OnHandUpdateExtendedDS
     * Meta information extracted from the WSDL
     * - documentation: Returns Dataset of OnHand Quantities with extra fields. (Fields: I=ItemNumber, P=Catalog Price, Q=Current Quantity, C=Customer Price, M=Mfg Item Number, U=UPC) | Returns Dataset of OnHand Quantities with extra fields. (Fields:
     * I=ItemNumber, P=Catalog Price, Q=Current Quantity, C=Customer Price, M=Mfg Item Number, U=UPC) | Returns Dataset of OnHand Quantities with extra fields. (Fields: I=ItemNumber, P=Catalog Price, Q=Current Quantity, C=Customer Price, M=Mfg Item Number,
     * U=UPC)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OnHandUpdateExtendedDS $parameters
     * @return \StructType\OnHandUpdateExtendedDSResponse|bool
     */
    public function OnHandUpdateExtendedDS(\StructType\OnHandUpdateExtendedDS $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OnHandUpdateExtendedDS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OnHandUpdateExtendedDSResponse|\StructType\OnHandUpdateExtendedResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
