<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Manufacturer ServiceType
 * @subpackage Services
 */
class Manufacturer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ManufacturerCategoriesDS
     * Meta information extracted from the WSDL
     * - documentation: Returns XML of Category Id / Category Description for a Manufacturer.<br>To view the schema of the input/return values of this function <a href="Schemas/MfgCats.xsl">Click Here</a> | Returns XML of Category Id / Category Description
     * for a Manufacturer.<br>To view the schema of the input/return values of this function <a href="Schemas/MfgCats.xsl">Click Here</a> | Returns XML of Category Id / Category Description for a Manufacturer.<br>To view the schema of the input/return
     * values of this function <a href="Schemas/MfgCats.xsl">Click Here</a>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ManufacturerCategoriesDS $parameters
     * @return \StructType\ManufacturerCategoriesDSResponse|bool
     */
    public function ManufacturerCategoriesDS(\StructType\ManufacturerCategoriesDS $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ManufacturerCategoriesDS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ManufacturerCategories
     * Meta information extracted from the WSDL
     * - documentation: Returns XML of Category Id / Category Description for a Manufacturer.<br>To view the schema of the input/return values of this function <a href="Schemas/MfgCats.xsl">Click Here</a> | Returns XML of Category Id / Category Description
     * for a Manufacturer.<br>To view the schema of the input/return values of this function <a href="Schemas/MfgCats.xsl">Click Here</a> | Returns XML of Category Id / Category Description for a Manufacturer.<br>To view the schema of the input/return
     * values of this function <a href="Schemas/MfgCats.xsl">Click Here</a>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ManufacturerCategories $parameters
     * @return \StructType\ManufacturerCategoriesResponse|bool
     */
    public function ManufacturerCategories(\StructType\ManufacturerCategories $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ManufacturerCategories($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ManufacturerUpdateDS
     * Meta information extracted from the WSDL
     * - documentation: Returns DATASET of Manufacturers.<br>To view the schema of the input/return values of this function <a href="Schemas/ManufacturerUpdate.xsl">Click Here</a> | Returns DATASET of Manufacturers.<br>To view the schema of the input/return
     * values of this function <a href="Schemas/ManufacturerUpdate.xsl">Click Here</a> | Returns DATASET of Manufacturers.<br>To view the schema of the input/return values of this function <a href="Schemas/ManufacturerUpdate.xsl">Click Here</a>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ManufacturerUpdateDS $parameters
     * @return \StructType\ManufacturerUpdateDSResponse|bool
     */
    public function ManufacturerUpdateDS(\StructType\ManufacturerUpdateDS $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ManufacturerUpdateDS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ManufacturerUpdate
     * Meta information extracted from the WSDL
     * - documentation: Returns XML of Manufacturers.<br>To view the schema of the input/return values of this function <a href="Schemas/ManufacturerUpdate.xsl">Click Here</a> | Returns XML of Manufacturers.<br>To view the schema of the input/return values
     * of this function <a href="Schemas/ManufacturerUpdate.xsl">Click Here</a> | Returns XML of Manufacturers.<br>To view the schema of the input/return values of this function <a href="Schemas/ManufacturerUpdate.xsl">Click Here</a>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ManufacturerUpdate $parameters
     * @return \StructType\ManufacturerUpdateResponse|bool
     */
    public function ManufacturerUpdate(\StructType\ManufacturerUpdate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ManufacturerUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ManufacturerCategoriesDSResponse|\StructType\ManufacturerCategoriesResponse|\StructType\ManufacturerUpdateDSResponse|\StructType\ManufacturerUpdateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
