<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Category ServiceType
 * @subpackage Services
 */
class Category extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CategoryUpdateDS
     * Meta information extracted from the WSDL
     * - documentation: Returns DATASET of category descriptions and attribute field names for each category.<br>To view the schema of the input/return values of this function <a href="Schemas/CategoryUpdate.xsl">Click Here</a> | Returns DATASET of category
     * descriptions and attribute field names for each category.<br>To view the schema of the input/return values of this function <a href="Schemas/CategoryUpdate.xsl">Click Here</a> | Returns DATASET of category descriptions and attribute field names for
     * each category.<br>To view the schema of the input/return values of this function <a href="Schemas/CategoryUpdate.xsl">Click Here</a>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CategoryUpdateDS $parameters
     * @return \StructType\CategoryUpdateDSResponse|bool
     */
    public function CategoryUpdateDS(\StructType\CategoryUpdateDS $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CategoryUpdateDS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CategoryUpdate
     * Meta information extracted from the WSDL
     * - documentation: Returns XML of category descriptions and attribute field names for each category.<br>To view the schema of the input/return values of this function <a href="Schemas/CategoryUpdate.xsl">Click Here</a> | Returns XML of category
     * descriptions and attribute field names for each category.<br>To view the schema of the input/return values of this function <a href="Schemas/CategoryUpdate.xsl">Click Here</a> | Returns XML of category descriptions and attribute field names for each
     * category.<br>To view the schema of the input/return values of this function <a href="Schemas/CategoryUpdate.xsl">Click Here</a>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CategoryUpdate $parameters
     * @return \StructType\CategoryUpdateResponse|bool
     */
    public function CategoryUpdate(\StructType\CategoryUpdate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CategoryUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CategorySearchFieldsDS
     * Meta information extracted from the WSDL
     * - documentation: Returns DATASET of Category Search Fields for each category.<br>To view the schema of the input/return values of this function <a href="Schemas/CategorySearchFields.xsl">Click Here</a> | Returns DATASET of Category Search Fields for
     * each category.<br>To view the schema of the input/return values of this function <a href="Schemas/CategorySearchFields.xsl">Click Here</a> | Returns DATASET of Category Search Fields for each category.<br>To view the schema of the input/return values
     * of this function <a href="Schemas/CategorySearchFields.xsl">Click Here</a>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CategorySearchFieldsDS $parameters
     * @return \StructType\CategorySearchFieldsDSResponse|bool
     */
    public function CategorySearchFieldsDS(\StructType\CategorySearchFieldsDS $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CategorySearchFieldsDS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CategorySearchFields
     * Meta information extracted from the WSDL
     * - documentation: Returns XML of Category Search Fields for each category.<br>To view the schema of the input/return values of this function <a href="Schemas/CategorySearchFields.xsl">Click Here</a> | Returns XML of Category Search Fields for each
     * category.<br>To view the schema of the input/return values of this function <a href="Schemas/CategorySearchFields.xsl">Click Here</a> | Returns XML of Category Search Fields for each category.<br>To view the schema of the input/return values of this
     * function <a href="Schemas/CategorySearchFields.xsl">Click Here</a>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CategorySearchFields $parameters
     * @return \StructType\CategorySearchFieldsResponse|bool
     */
    public function CategorySearchFields(\StructType\CategorySearchFields $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CategorySearchFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CategorySearchFieldsDSResponse|\StructType\CategorySearchFieldsResponse|\StructType\CategoryUpdateDSResponse|\StructType\CategoryUpdateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
