<?php

namespace EnumType;

/**
 * This class stands for DisputeStateCodeType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Defines the current state of the dispute, which determines the values that are valid for DisputeActivity. DisputeState is an internal value returned in the response. A value can apply to an Unpaid Item or Item Not Received dispute. A
 * dispute filed when an item is significantly not as described in the product listing is a variation of an Item Not Received dispute. <br/><br/> <span class="tablenote"><strong>Note:</strong> These are not eBay money back guarantee disputes. </span>
 * @subpackage Enumerations
 */
class DisputeStateCodeType
{
    /**
     * Constant for value 'Locked'
     * Meta informations extracted from the WSDL
     * - documentation: The dispute is locked and cannot be updated. For any type of dispute. No values of DisputeActivity are valid.
     * @return string 'Locked'
     */
    const VALUE_LOCKED = 'Locked';
    /**
     * Constant for value 'Closed'
     * Meta informations extracted from the WSDL
     * - documentation: The dispute is closed. In some cases, it can be reversed with SellerReverseDispute. For any type of dispute. No values of DisputeActivity are valid.
     * @return string 'Closed'
     */
    const VALUE_CLOSED = 'Closed';
    /**
     * Constant for value 'BuyerFirstResponsePayOption'
     * Meta informations extracted from the WSDL
     * - documentation: eBay sent the buyer an Unpaid Item Reminder with a Pay Now option. Waiting for the buyer's first response. It is within the 7-day grace period. For Unpaid Item Disputes. DisputeActivity can be SellerAddInformation or
     * SellerCompletedTransaction.
     * @return string 'BuyerFirstResponsePayOption'
     */
    const VALUE_BUYER_FIRST_RESPONSE_PAY_OPTION = 'BuyerFirstResponsePayOption';
    /**
     * Constant for value 'BuyerFirstResponseNoPayOption'
     * Meta informations extracted from the WSDL
     * - documentation: eBay sent the buyer an Unpaid Item Reminder with no Pay Now option. Waiting for the buyer's first response. It is within the 7-day grace period. For Unpaid Item Disputes. DisputeActivity can be SellerAddInformation or
     * SellerCompletedTransaction.
     * @return string 'BuyerFirstResponseNoPayOption'
     */
    const VALUE_BUYER_FIRST_RESPONSE_NO_PAY_OPTION = 'BuyerFirstResponseNoPayOption';
    /**
     * Constant for value 'BuyerFirstResponsePayOptionLateResponse'
     * Meta informations extracted from the WSDL
     * - documentation: eBay sent the buyer an Unpaid Item Reminder with a Pay Now option. Waiting for the buyer's first response. The 7-day grace period has expired. For Unpaid Item Disputes. DisputeActivity can be SellerAddInformation,
     * SellerCompletedTransaction, or SellerEndCommunication.
     * @return string 'BuyerFirstResponsePayOptionLateResponse'
     */
    const VALUE_BUYER_FIRST_RESPONSE_PAY_OPTION_LATE_RESPONSE = 'BuyerFirstResponsePayOptionLateResponse';
    /**
     * Constant for value 'BuyerFirstResponseNoPayOptionLateResponse'
     * Meta informations extracted from the WSDL
     * - documentation: eBay sent the buyer an Unpaid Item Reminder with no Pay Now option. Waiting for the buyer's first response. The 7-day grace period has expired. For Unpaid Item Disputes. DisputeActivity can be SellerAddInformation,
     * SellerCompletedTransaction, or SellerEndCommunication.
     * @return string 'BuyerFirstResponseNoPayOptionLateResponse'
     */
    const VALUE_BUYER_FIRST_RESPONSE_NO_PAY_OPTION_LATE_RESPONSE = 'BuyerFirstResponseNoPayOptionLateResponse';
    /**
     * Constant for value 'MutualCommunicationPayOption'
     * Meta informations extracted from the WSDL
     * - documentation: The buyer and seller have communicated, and eBay offered the buyer a Pay Now option. For Unpaid Item Disputes. DisputeActivity can be SellerAddInformation, SellerCompletedTransaction, SellerEndCommunication, or
     * CameToAgreementNeedFVFCredit.
     * @return string 'MutualCommunicationPayOption'
     */
    const VALUE_MUTUAL_COMMUNICATION_PAY_OPTION = 'MutualCommunicationPayOption';
    /**
     * Constant for value 'MutualCommunicationNoPayOption'
     * Meta informations extracted from the WSDL
     * - documentation: The buyer and seller have communicated. eBay did not offer the buyer a Pay Now option. For Unpaid Item Disputes. DisputeActivity can be SellerAddInformation, SellerCompletedTransaction, SellerEndCommunication, or
     * CameToAgreementNeedFVFCredit.
     * @return string 'MutualCommunicationNoPayOption'
     */
    const VALUE_MUTUAL_COMMUNICATION_NO_PAY_OPTION = 'MutualCommunicationNoPayOption';
    /**
     * Constant for value 'PendingResolve'
     * Meta informations extracted from the WSDL
     * - documentation: The dispute is pending resolution. A dispute cannot be closed when it is in this state. For Unpaid Item Disputes. No values of DisputeActivity are valid.
     * @return string 'PendingResolve'
     */
    const VALUE_PENDING_RESOLVE = 'PendingResolve';
    /**
     * Constant for value 'MutualWithdrawalAgreement'
     * Meta informations extracted from the WSDL
     * - documentation: The buyer and seller have agreed within the grace period not to complete the transaction. For Unpaid Item Disputes. DisputeActivity can be SellerAddInformation.
     * @return string 'MutualWithdrawalAgreement'
     */
    const VALUE_MUTUAL_WITHDRAWAL_AGREEMENT = 'MutualWithdrawalAgreement';
    /**
     * Constant for value 'MutualWithdrawalAgreementLate'
     * Meta informations extracted from the WSDL
     * - documentation: The buyer and seller have agreed not to complete the transaction, after the grace period. For Unpaid Item Disputes. DisputeActivity can be SellerAddInformation, SellerCompletedTransaction, or SellerEndCommunication.
     * @return string 'MutualWithdrawalAgreementLate'
     */
    const VALUE_MUTUAL_WITHDRAWAL_AGREEMENT_LATE = 'MutualWithdrawalAgreementLate';
    /**
     * Constant for value 'NotReceivedNoSellerResponse'
     * Meta informations extracted from the WSDL
     * - documentation: The buyer filed an Item Not Received dispute, and the seller has not responded. For Item Not Received disputes. DisputeActivity can be SellerOffersRefund, SellerShippedItem, or SellerComment.
     * @return string 'NotReceivedNoSellerResponse'
     */
    const VALUE_NOT_RECEIVED_NO_SELLER_RESPONSE = 'NotReceivedNoSellerResponse';
    /**
     * Constant for value 'NotAsDescribedNoSellerResponse'
     * Meta informations extracted from the WSDL
     * - documentation: The buyer filed an Item Not Received dispute for an item significantly not as described, and the seller has not responded. DisputeActivity can be SellerOffersRefund or SellerComment.
     * @return string 'NotAsDescribedNoSellerResponse'
     */
    const VALUE_NOT_AS_DESCRIBED_NO_SELLER_RESPONSE = 'NotAsDescribedNoSellerResponse';
    /**
     * Constant for value 'NotReceivedMutualCommunication'
     * Meta informations extracted from the WSDL
     * - documentation: The buyer filed an Item Not Received dispute and is communicating with the seller. DisputeActivity can be SellerOffersRefund, SellerShippedItem, or SellerComment.
     * @return string 'NotReceivedMutualCommunication'
     */
    const VALUE_NOT_RECEIVED_MUTUAL_COMMUNICATION = 'NotReceivedMutualCommunication';
    /**
     * Constant for value 'NotAsDescribedMutualCommunication'
     * Meta informations extracted from the WSDL
     * - documentation: The buyer filed an Item Not Received dispute for an item significantly not as described and is communicating with the seller. DisputeActivity can be SellerOffersRefund.
     * @return string 'NotAsDescribedMutualCommunication'
     */
    const VALUE_NOT_AS_DESCRIBED_MUTUAL_COMMUNICATION = 'NotAsDescribedMutualCommunication';
    /**
     * Constant for value 'MutualAgreementOrBuyerReturningItem'
     * Meta informations extracted from the WSDL
     * - documentation: The seller says mutual agreement has been reached and is waiting for the buyer to confirm, or the buyer is returning the item to the seller. DisputeActivity can be SellerAddInformation. For Unpaid Item Disputes.
     * @return string 'MutualAgreementOrBuyerReturningItem'
     */
    const VALUE_MUTUAL_AGREEMENT_OR_BUYER_RETURNING_ITEM = 'MutualAgreementOrBuyerReturningItem';
    /**
     * Constant for value 'ClaimOpened'
     * Meta informations extracted from the WSDL
     * - documentation: The claim was assigned to an adjuster.
     * @return string 'ClaimOpened'
     */
    const VALUE_CLAIM_OPENED = 'ClaimOpened';
    /**
     * Constant for value 'NoDocumentation'
     * Meta informations extracted from the WSDL
     * - documentation: The buyer was contacted by eBay and asked to submit paperwork to support the claim.
     * @return string 'NoDocumentation'
     */
    const VALUE_NO_DOCUMENTATION = 'NoDocumentation';
    /**
     * Constant for value 'ClaimClosed'
     * Meta informations extracted from the WSDL
     * - documentation: The buyer did not respond to verification or was missing paperwork.
     * @return string 'ClaimClosed'
     */
    const VALUE_CLAIM_CLOSED = 'ClaimClosed';
    /**
     * Constant for value 'ClaimDenied'
     * Meta informations extracted from the WSDL
     * - documentation: The buyer is not eligible for reimbursement.
     * @return string 'ClaimDenied'
     */
    const VALUE_CLAIM_DENIED = 'ClaimDenied';
    /**
     * Constant for value 'ClaimPending'
     * Meta informations extracted from the WSDL
     * - documentation: Paperwork was received from the buyer and the claim is being investigated.
     * @return string 'ClaimPending'
     */
    const VALUE_CLAIM_PENDING = 'ClaimPending';
    /**
     * Constant for value 'ClaimPaymentPending'
     * Meta informations extracted from the WSDL
     * - documentation: The buyer's claim was approved for reimbursement and was sent to accounts payable for payment.
     * @return string 'ClaimPaymentPending'
     */
    const VALUE_CLAIM_PAYMENT_PENDING = 'ClaimPaymentPending';
    /**
     * Constant for value 'ClaimPaid'
     * Meta informations extracted from the WSDL
     * - documentation: The buyer was reimbursed.
     * @return string 'ClaimPaid'
     */
    const VALUE_CLAIM_PAID = 'ClaimPaid';
    /**
     * Constant for value 'ClaimResolved'
     * Meta informations extracted from the WSDL
     * - documentation: The issue has been resolved: the seller sent the item or a refund.
     * @return string 'ClaimResolved'
     */
    const VALUE_CLAIM_RESOLVED = 'ClaimResolved';
    /**
     * Constant for value 'ClaimSubmitted'
     * Meta informations extracted from the WSDL
     * - documentation: A claim was submitted (via Web).
     * @return string 'ClaimSubmitted'
     */
    const VALUE_CLAIM_SUBMITTED = 'ClaimSubmitted';
    /**
     * Constant for value 'UnpaidItemOpen'
     * Meta informations extracted from the WSDL
     * - documentation: The unpaid item dispute is open.
     * @return string 'UnpaidItemOpen'
     */
    const VALUE_UNPAID_ITEM_OPEN = 'UnpaidItemOpen';
    /**
     * Constant for value 'UPIAssistanceDisabledByeBay'
     * Meta informations extracted from the WSDL
     * - documentation: An unpaid item dispute filed by the Unpaid Item Assistance mechanism was disabled by eBay (for example, eBay detected that payment was initiated and the seller needs to manually handle this dispute).
     * @return string 'UPIAssistanceDisabledByeBay'
     */
    const VALUE_UPIASSISTANCE_DISABLED_BYE_BAY = 'UPIAssistanceDisabledByeBay';
    /**
     * Constant for value 'UPIAssistanceDisabledBySeller'
     * Meta informations extracted from the WSDL
     * - documentation: An unpaid item dispute filed by the Unpaid Item Assistance mechanism was disabled by the seller (e.g. the buyer and seller have communicated about payment and the seller wishes to extend the time for payment and not let the automatic
     * process close the dispute 4 days after the dispute was automatically opened).
     * @return string 'UPIAssistanceDisabledBySeller'
     */
    const VALUE_UPIASSISTANCE_DISABLED_BY_SELLER = 'UPIAssistanceDisabledBySeller';
    /**
     * Constant for value 'CustomCode'
     * Meta informations extracted from the WSDL
     * - documentation: Reserved for internal or future use.
     * @return string 'CustomCode'
     */
    const VALUE_CUSTOM_CODE = 'CustomCode';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LOCKED
     * @uses self::VALUE_CLOSED
     * @uses self::VALUE_BUYER_FIRST_RESPONSE_PAY_OPTION
     * @uses self::VALUE_BUYER_FIRST_RESPONSE_NO_PAY_OPTION
     * @uses self::VALUE_BUYER_FIRST_RESPONSE_PAY_OPTION_LATE_RESPONSE
     * @uses self::VALUE_BUYER_FIRST_RESPONSE_NO_PAY_OPTION_LATE_RESPONSE
     * @uses self::VALUE_MUTUAL_COMMUNICATION_PAY_OPTION
     * @uses self::VALUE_MUTUAL_COMMUNICATION_NO_PAY_OPTION
     * @uses self::VALUE_PENDING_RESOLVE
     * @uses self::VALUE_MUTUAL_WITHDRAWAL_AGREEMENT
     * @uses self::VALUE_MUTUAL_WITHDRAWAL_AGREEMENT_LATE
     * @uses self::VALUE_NOT_RECEIVED_NO_SELLER_RESPONSE
     * @uses self::VALUE_NOT_AS_DESCRIBED_NO_SELLER_RESPONSE
     * @uses self::VALUE_NOT_RECEIVED_MUTUAL_COMMUNICATION
     * @uses self::VALUE_NOT_AS_DESCRIBED_MUTUAL_COMMUNICATION
     * @uses self::VALUE_MUTUAL_AGREEMENT_OR_BUYER_RETURNING_ITEM
     * @uses self::VALUE_CLAIM_OPENED
     * @uses self::VALUE_NO_DOCUMENTATION
     * @uses self::VALUE_CLAIM_CLOSED
     * @uses self::VALUE_CLAIM_DENIED
     * @uses self::VALUE_CLAIM_PENDING
     * @uses self::VALUE_CLAIM_PAYMENT_PENDING
     * @uses self::VALUE_CLAIM_PAID
     * @uses self::VALUE_CLAIM_RESOLVED
     * @uses self::VALUE_CLAIM_SUBMITTED
     * @uses self::VALUE_UNPAID_ITEM_OPEN
     * @uses self::VALUE_UPIASSISTANCE_DISABLED_BYE_BAY
     * @uses self::VALUE_UPIASSISTANCE_DISABLED_BY_SELLER
     * @uses self::VALUE_CUSTOM_CODE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LOCKED,
            self::VALUE_CLOSED,
            self::VALUE_BUYER_FIRST_RESPONSE_PAY_OPTION,
            self::VALUE_BUYER_FIRST_RESPONSE_NO_PAY_OPTION,
            self::VALUE_BUYER_FIRST_RESPONSE_PAY_OPTION_LATE_RESPONSE,
            self::VALUE_BUYER_FIRST_RESPONSE_NO_PAY_OPTION_LATE_RESPONSE,
            self::VALUE_MUTUAL_COMMUNICATION_PAY_OPTION,
            self::VALUE_MUTUAL_COMMUNICATION_NO_PAY_OPTION,
            self::VALUE_PENDING_RESOLVE,
            self::VALUE_MUTUAL_WITHDRAWAL_AGREEMENT,
            self::VALUE_MUTUAL_WITHDRAWAL_AGREEMENT_LATE,
            self::VALUE_NOT_RECEIVED_NO_SELLER_RESPONSE,
            self::VALUE_NOT_AS_DESCRIBED_NO_SELLER_RESPONSE,
            self::VALUE_NOT_RECEIVED_MUTUAL_COMMUNICATION,
            self::VALUE_NOT_AS_DESCRIBED_MUTUAL_COMMUNICATION,
            self::VALUE_MUTUAL_AGREEMENT_OR_BUYER_RETURNING_ITEM,
            self::VALUE_CLAIM_OPENED,
            self::VALUE_NO_DOCUMENTATION,
            self::VALUE_CLAIM_CLOSED,
            self::VALUE_CLAIM_DENIED,
            self::VALUE_CLAIM_PENDING,
            self::VALUE_CLAIM_PAYMENT_PENDING,
            self::VALUE_CLAIM_PAID,
            self::VALUE_CLAIM_RESOLVED,
            self::VALUE_CLAIM_SUBMITTED,
            self::VALUE_UNPAID_ITEM_OPEN,
            self::VALUE_UPIASSISTANCE_DISABLED_BYE_BAY,
            self::VALUE_UPIASSISTANCE_DISABLED_BY_SELLER,
            self::VALUE_CUSTOM_CODE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
