<?php

namespace EnumType;

/**
 * This class stands for AddressRecordTypeCodeType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: This enumerated type is deprecated.
 * @subpackage Enumerations
 */
class AddressRecordTypeCodeType
{
    /**
     * Constant for value 'Residential'
     * Meta informations extracted from the WSDL
     * - documentation: This value is not used.
     * @return string 'Residential'
     */
    const VALUE_RESIDENTIAL = 'Residential';
    /**
     * Constant for value 'Business'
     * Meta informations extracted from the WSDL
     * - documentation: This value is not used.
     * @return string 'Business'
     */
    const VALUE_BUSINESS = 'Business';
    /**
     * Constant for value 'CustomCode'
     * Meta informations extracted from the WSDL
     * - documentation: This value is not used.
     * @return string 'CustomCode'
     */
    const VALUE_CUSTOM_CODE = 'CustomCode';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_RESIDENTIAL
     * @uses self::VALUE_BUSINESS
     * @uses self::VALUE_CUSTOM_CODE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_RESIDENTIAL,
            self::VALUE_BUSINESS,
            self::VALUE_CUSTOM_CODE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
