<?php

namespace EnumType;

/**
 * This class stands for SellingManagerAlertTypeCodeType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Container for various alert types.
 * @subpackage Enumerations
 */
class SellingManagerAlertTypeCodeType
{
    /**
     * Constant for value 'Sold'
     * Meta informations extracted from the WSDL
     * - documentation: Indicates that an alert related to a sold listing has been issued.
     * @return string 'Sold'
     */
    const VALUE_SOLD = 'Sold';
    /**
     * Constant for value 'Inventory'
     * Meta informations extracted from the WSDL
     * - documentation: Indicates that an alert related to inventory has been issued.
     * @return string 'Inventory'
     */
    const VALUE_INVENTORY = 'Inventory';
    /**
     * Constant for value 'Automation'
     * Meta informations extracted from the WSDL
     * - documentation: Indicates that an automation alert has been sent because a listing did not conform to listing automation rules.
     * @return string 'Automation'
     */
    const VALUE_AUTOMATION = 'Automation';
    /**
     * Constant for value 'PaisaPay'
     * Meta informations extracted from the WSDL
     * - documentation: Indicates that an alert related to PaisaPay has been issued.
     * @return string 'PaisaPay'
     */
    const VALUE_PAISA_PAY = 'PaisaPay';
    /**
     * Constant for value 'General'
     * Meta informations extracted from the WSDL
     * - documentation: Indicates that an alert has been issued for negative feedback received, bad email, or an unpaid item dispute.
     * @return string 'General'
     */
    const VALUE_GENERAL = 'General';
    /**
     * Constant for value 'CustomCode'
     * Meta informations extracted from the WSDL
     * - documentation: (out) Reserved for internal or future use.
     * @return string 'CustomCode'
     */
    const VALUE_CUSTOM_CODE = 'CustomCode';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SOLD
     * @uses self::VALUE_INVENTORY
     * @uses self::VALUE_AUTOMATION
     * @uses self::VALUE_PAISA_PAY
     * @uses self::VALUE_GENERAL
     * @uses self::VALUE_CUSTOM_CODE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SOLD,
            self::VALUE_INVENTORY,
            self::VALUE_AUTOMATION,
            self::VALUE_PAISA_PAY,
            self::VALUE_GENERAL,
            self::VALUE_CUSTOM_CODE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
