<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetOrderTransactionsRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: The base request type for the <b>GetOrderTransactions</b> call. This call retrieves detailed information about one or more orders or order line items created (or modified) in the last 90 days. <br><br> Unlike <b>GetOrders</b>, which
 * can be used to retrieve specific orders, or orders created (or modified) within a specific time period, the <b>GetOrderTransactions</b> call only supports the retrieval of specific orders and/or order line items.
 * @subpackage Structs
 */
class GetOrderTransactionsRequestType extends AbstractRequestType
{
    /**
     * The ItemTransactionIDArray
     * Meta informations extracted from the WSDL
     * - documentation: This container is used if the seller wants to retrieve for one or more order line items. An <b>ItemTransactionID</b> container is required for each order line item that is to be retrieved. An order line item can be identified with an
     * <b>ItemID</b>/<b>TransactionID</b> pair, with a <b>OrderLineItemID</b> value, or with a <b>SKU</b> value (if a SKU is defined for the order line item).
     * - minOccurs: 0
     * @var \ArrayType\ItemTransactionIDArrayType
     */
    public $ItemTransactionIDArray;
    /**
     * The OrderIDArray
     * Meta informations extracted from the WSDL
     * - documentation: This container is used if the seller wants to search for one or more orders. An <b>OrderID</b> field is required for each order that is to be retrieved. Up to 20 <b>OrderID</b> fields can be used.
     * - minOccurs: 0
     * @var \ArrayType\OrderIDArrayType
     */
    public $OrderIDArray;
    /**
     * The Platform
     * Meta informations extracted from the WSDL
     * - documentation: <span class="tablenote"><b>Note: </b> This field should no longer be used since its sole purpose was to allow the seller to filter between eBay orders and Half.com orders, and the Half.com site no longer exists. </span>
     * - minOccurs: 0
     * @var string
     */
    public $Platform;
    /**
     * The IncludeFinalValueFees
     * Meta informations extracted from the WSDL
     * - documentation: This field is included and set to <code>true</code> if the user wants to view the Final Value Fee (FVF) for all order line items in the response. The Final Value Fee is returned in the <b>Transaction.FinalValueFee</b> field. The
     * Final Value Fee is assessed right after the creation of an order line item. <br/>
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeFinalValueFees;
    /**
     * Constructor method for GetOrderTransactionsRequestType
     * @uses GetOrderTransactionsRequestType::setItemTransactionIDArray()
     * @uses GetOrderTransactionsRequestType::setOrderIDArray()
     * @uses GetOrderTransactionsRequestType::setPlatform()
     * @uses GetOrderTransactionsRequestType::setIncludeFinalValueFees()
     * @param \ArrayType\ItemTransactionIDArrayType $itemTransactionIDArray
     * @param \ArrayType\OrderIDArrayType $orderIDArray
     * @param string $platform
     * @param bool $includeFinalValueFees
     */
    public function __construct(\ArrayType\ItemTransactionIDArrayType $itemTransactionIDArray = null, \ArrayType\OrderIDArrayType $orderIDArray = null, $platform = null, $includeFinalValueFees = null)
    {
        $this
            ->setItemTransactionIDArray($itemTransactionIDArray)
            ->setOrderIDArray($orderIDArray)
            ->setPlatform($platform)
            ->setIncludeFinalValueFees($includeFinalValueFees);
    }
    /**
     * Get ItemTransactionIDArray value
     * @return \ArrayType\ItemTransactionIDArrayType|null
     */
    public function getItemTransactionIDArray()
    {
        return $this->ItemTransactionIDArray;
    }
    /**
     * Set ItemTransactionIDArray value
     * @param \ArrayType\ItemTransactionIDArrayType $itemTransactionIDArray
     * @return \StructType\GetOrderTransactionsRequestType
     */
    public function setItemTransactionIDArray(\ArrayType\ItemTransactionIDArrayType $itemTransactionIDArray = null)
    {
        $this->ItemTransactionIDArray = $itemTransactionIDArray;
        return $this;
    }
    /**
     * Get OrderIDArray value
     * @return \ArrayType\OrderIDArrayType|null
     */
    public function getOrderIDArray()
    {
        return $this->OrderIDArray;
    }
    /**
     * Set OrderIDArray value
     * @param \ArrayType\OrderIDArrayType $orderIDArray
     * @return \StructType\GetOrderTransactionsRequestType
     */
    public function setOrderIDArray(\ArrayType\OrderIDArrayType $orderIDArray = null)
    {
        $this->OrderIDArray = $orderIDArray;
        return $this;
    }
    /**
     * Get Platform value
     * @return string|null
     */
    public function getPlatform()
    {
        return $this->Platform;
    }
    /**
     * Set Platform value
     * @uses \EnumType\TransactionPlatformCodeType::valueIsValid()
     * @uses \EnumType\TransactionPlatformCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $platform
     * @return \StructType\GetOrderTransactionsRequestType
     */
    public function setPlatform($platform = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransactionPlatformCodeType::valueIsValid($platform)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransactionPlatformCodeType', is_array($platform) ? implode(', ', $platform) : var_export($platform, true), implode(', ', \EnumType\TransactionPlatformCodeType::getValidValues())), __LINE__);
        }
        $this->Platform = $platform;
        return $this;
    }
    /**
     * Get IncludeFinalValueFees value
     * @return bool|null
     */
    public function getIncludeFinalValueFees()
    {
        return $this->IncludeFinalValueFees;
    }
    /**
     * Set IncludeFinalValueFees value
     * @param bool $includeFinalValueFees
     * @return \StructType\GetOrderTransactionsRequestType
     */
    public function setIncludeFinalValueFees($includeFinalValueFees = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeFinalValueFees) && !is_bool($includeFinalValueFees)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeFinalValueFees, true), gettype($includeFinalValueFees)), __LINE__);
        }
        $this->IncludeFinalValueFees = $includeFinalValueFees;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetOrderTransactionsRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
