<?php

namespace EnumType;

/**
 * This class stands for DisputeStatusCodeType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Describes the status of the dispute, which supplements the DisputeState. Some values apply to Unpaid Item disputes and some to Item Not Received disputes. Disputes can be sorted by DisputeStatus. Ascending order is:<br> 1 -
 * WaitingForSellerResponse<br> 2 - WaitingForBuyerResponse<br> 3 - ClosedFVFCreditStrike<br> 4 - ClosedNoFVFCreditStrike<br> 5 - ClosedFVFCreditNoStrike<br> 6 - ClosedNoFVFCreditNoStrike<br> 7 - Closed<br> 8 - StrikeAppealedAfterClosing<br> 9 -
 * FVFCreditReversedAfterClosing<br> 10 - StrikeAppealedAndFVFCreditReversed<br> Descending order is the reverse. <br/><br/> <span class="tablenote"><strong>Note:</strong> These are not eBay money back guarantee disputes. </span>
 * @subpackage Enumerations
 */
class DisputeStatusCodeType
{
    /**
     * Constant for value 'Closed'
     * Meta informations extracted from the WSDL
     * - documentation: The dispute is closed. For Item Not Received disputes.
     * @return string 'Closed'
     */
    const VALUE_CLOSED = 'Closed';
    /**
     * Constant for value 'WaitingForSellerResponse'
     * Meta informations extracted from the WSDL
     * - documentation: The dispute is waiting for the seller's response. For both Unpaid Item and Item Not Received disputes.
     * @return string 'WaitingForSellerResponse'
     */
    const VALUE_WAITING_FOR_SELLER_RESPONSE = 'WaitingForSellerResponse';
    /**
     * Constant for value 'WaitingForBuyerResponse'
     * Meta informations extracted from the WSDL
     * - documentation: The dispute is waiting for the buyer's response. For both Unpaid Item and Item Not Received disputes.
     * @return string 'WaitingForBuyerResponse'
     */
    const VALUE_WAITING_FOR_BUYER_RESPONSE = 'WaitingForBuyerResponse';
    /**
     * Constant for value 'ClosedFVFCreditStrike'
     * Meta informations extracted from the WSDL
     * - documentation: The dispute is closed, the seller received a Final Value Fee credit, and the buyer received a strike. For Unpaid Item disputes.
     * @return string 'ClosedFVFCreditStrike'
     */
    const VALUE_CLOSED_FVFCREDIT_STRIKE = 'ClosedFVFCreditStrike';
    /**
     * Constant for value 'ClosedNoFVFCreditStrike'
     * Meta informations extracted from the WSDL
     * - documentation: The dispute is closed, the seller did not receive a Final Value Fee credit, and the buyer received a strike. For Unpaid Item disputes.
     * @return string 'ClosedNoFVFCreditStrike'
     */
    const VALUE_CLOSED_NO_FVFCREDIT_STRIKE = 'ClosedNoFVFCreditStrike';
    /**
     * Constant for value 'ClosedFVFCreditNoStrike'
     * Meta informations extracted from the WSDL
     * - documentation: The dispute is closed, the seller received a Final Value Fee credit, and the buyer did not receive a strike. For Unpaid Item disputes.
     * @return string 'ClosedFVFCreditNoStrike'
     */
    const VALUE_CLOSED_FVFCREDIT_NO_STRIKE = 'ClosedFVFCreditNoStrike';
    /**
     * Constant for value 'ClosedNoFVFCreditNoStrike'
     * Meta informations extracted from the WSDL
     * - documentation: The dispute is closed, the seller did not receive a Final Value Fee credit, and the buyer did not receive a strike. For Unpaid Item disputes.
     * @return string 'ClosedNoFVFCreditNoStrike'
     */
    const VALUE_CLOSED_NO_FVFCREDIT_NO_STRIKE = 'ClosedNoFVFCreditNoStrike';
    /**
     * Constant for value 'StrikeAppealedAfterClosing'
     * Meta informations extracted from the WSDL
     * - documentation: The buyer's strike was appealed after the dispute was closed. For Unpaid Item disputes.
     * @return string 'StrikeAppealedAfterClosing'
     */
    const VALUE_STRIKE_APPEALED_AFTER_CLOSING = 'StrikeAppealedAfterClosing';
    /**
     * Constant for value 'FVFCreditReversedAfterClosing'
     * Meta informations extracted from the WSDL
     * - documentation: The seller's Final Value Fee credit was reversed after the dispute was closed. For Unpaid Item disputes.
     * @return string 'FVFCreditReversedAfterClosing'
     */
    const VALUE_FVFCREDIT_REVERSED_AFTER_CLOSING = 'FVFCreditReversedAfterClosing';
    /**
     * Constant for value 'StrikeAppealedAndFVFCreditReversed'
     * Meta informations extracted from the WSDL
     * - documentation: Both the seller's Final Value Fee credit and the buyer's strike were reversed after the dispute was closed. For Unpaid Item disputes.
     * @return string 'StrikeAppealedAndFVFCreditReversed'
     */
    const VALUE_STRIKE_APPEALED_AND_FVFCREDIT_REVERSED = 'StrikeAppealedAndFVFCreditReversed';
    /**
     * Constant for value 'ClaimOpened'
     * Meta informations extracted from the WSDL
     * - documentation: Claim assigned to an adjuster. Also maps for filed claim in Half.com
     * @return string 'ClaimOpened'
     */
    const VALUE_CLAIM_OPENED = 'ClaimOpened';
    /**
     * Constant for value 'NoDocumentation'
     * Meta informations extracted from the WSDL
     * - documentation: Buyer contacted and asked to submit paperwork
     * @return string 'NoDocumentation'
     */
    const VALUE_NO_DOCUMENTATION = 'NoDocumentation';
    /**
     * Constant for value 'ClaimClosed'
     * Meta informations extracted from the WSDL
     * - documentation: Buyer did not respond to verification or missing some paperwork. Also maps for filed claim in Half.com
     * @return string 'ClaimClosed'
     */
    const VALUE_CLAIM_CLOSED = 'ClaimClosed';
    /**
     * Constant for value 'ClaimDenied'
     * Meta informations extracted from the WSDL
     * - documentation: Not eligible for reimbursement
     * @return string 'ClaimDenied'
     */
    const VALUE_CLAIM_DENIED = 'ClaimDenied';
    /**
     * Constant for value 'ClaimInProcess'
     * Meta informations extracted from the WSDL
     * - documentation: Paperwork received, claim being investigated. Also maps for filed claim in Half.com
     * @return string 'ClaimInProcess'
     */
    const VALUE_CLAIM_IN_PROCESS = 'ClaimInProcess';
    /**
     * Constant for value 'ClaimApproved'
     * Meta informations extracted from the WSDL
     * - documentation: Claim approved for reimbursement; sent to accounts payable for payment
     * @return string 'ClaimApproved'
     */
    const VALUE_CLAIM_APPROVED = 'ClaimApproved';
    /**
     * Constant for value 'ClaimPaid'
     * Meta informations extracted from the WSDL
     * - documentation: Reimbursement completed
     * @return string 'ClaimPaid'
     */
    const VALUE_CLAIM_PAID = 'ClaimPaid';
    /**
     * Constant for value 'ClaimResolved'
     * Meta informations extracted from the WSDL
     * - documentation: Issue resolved: seller sent Item or Refund
     * @return string 'ClaimResolved'
     */
    const VALUE_CLAIM_RESOLVED = 'ClaimResolved';
    /**
     * Constant for value 'ClaimSubmitted'
     * Meta informations extracted from the WSDL
     * - documentation: Claim Submitted via Web flow
     * @return string 'ClaimSubmitted'
     */
    const VALUE_CLAIM_SUBMITTED = 'ClaimSubmitted';
    /**
     * Constant for value 'UnpaidItemOpened'
     * Meta informations extracted from the WSDL
     * - documentation: Unpaid Item dispute opened
     * @return string 'UnpaidItemOpened'
     */
    const VALUE_UNPAID_ITEM_OPENED = 'UnpaidItemOpened';
    /**
     * Constant for value 'CustomCode'
     * Meta informations extracted from the WSDL
     * - documentation: Reserved for internal or future use.
     * @return string 'CustomCode'
     */
    const VALUE_CUSTOM_CODE = 'CustomCode';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CLOSED
     * @uses self::VALUE_WAITING_FOR_SELLER_RESPONSE
     * @uses self::VALUE_WAITING_FOR_BUYER_RESPONSE
     * @uses self::VALUE_CLOSED_FVFCREDIT_STRIKE
     * @uses self::VALUE_CLOSED_NO_FVFCREDIT_STRIKE
     * @uses self::VALUE_CLOSED_FVFCREDIT_NO_STRIKE
     * @uses self::VALUE_CLOSED_NO_FVFCREDIT_NO_STRIKE
     * @uses self::VALUE_STRIKE_APPEALED_AFTER_CLOSING
     * @uses self::VALUE_FVFCREDIT_REVERSED_AFTER_CLOSING
     * @uses self::VALUE_STRIKE_APPEALED_AND_FVFCREDIT_REVERSED
     * @uses self::VALUE_CLAIM_OPENED
     * @uses self::VALUE_NO_DOCUMENTATION
     * @uses self::VALUE_CLAIM_CLOSED
     * @uses self::VALUE_CLAIM_DENIED
     * @uses self::VALUE_CLAIM_IN_PROCESS
     * @uses self::VALUE_CLAIM_APPROVED
     * @uses self::VALUE_CLAIM_PAID
     * @uses self::VALUE_CLAIM_RESOLVED
     * @uses self::VALUE_CLAIM_SUBMITTED
     * @uses self::VALUE_UNPAID_ITEM_OPENED
     * @uses self::VALUE_CUSTOM_CODE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CLOSED,
            self::VALUE_WAITING_FOR_SELLER_RESPONSE,
            self::VALUE_WAITING_FOR_BUYER_RESPONSE,
            self::VALUE_CLOSED_FVFCREDIT_STRIKE,
            self::VALUE_CLOSED_NO_FVFCREDIT_STRIKE,
            self::VALUE_CLOSED_FVFCREDIT_NO_STRIKE,
            self::VALUE_CLOSED_NO_FVFCREDIT_NO_STRIKE,
            self::VALUE_STRIKE_APPEALED_AFTER_CLOSING,
            self::VALUE_FVFCREDIT_REVERSED_AFTER_CLOSING,
            self::VALUE_STRIKE_APPEALED_AND_FVFCREDIT_REVERSED,
            self::VALUE_CLAIM_OPENED,
            self::VALUE_NO_DOCUMENTATION,
            self::VALUE_CLAIM_CLOSED,
            self::VALUE_CLAIM_DENIED,
            self::VALUE_CLAIM_IN_PROCESS,
            self::VALUE_CLAIM_APPROVED,
            self::VALUE_CLAIM_PAID,
            self::VALUE_CLAIM_RESOLVED,
            self::VALUE_CLAIM_SUBMITTED,
            self::VALUE_UNPAID_ITEM_OPENED,
            self::VALUE_CUSTOM_CODE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
