<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for FeedbackPeriodArrayType ArrayType
 * Meta informations extracted from the WSDL
 * - documentation: Container for a set of feedback statistics. Contains zero one or multiple FeedbackPeriod objects. Output only, for the summary feedback data returned by GetFeedback.
 * @subpackage Arrays
 */
class FeedbackPeriodArrayType extends AbstractStructArrayBase
{
    /**
     * The FeedbackPeriod
     * Meta informations extracted from the WSDL
     * - documentation: Contains one feedback statistic giving length of the period being reported (e.g. last 7 days prior to the call), and total number of feedback entries (of the type given by the container, e.g. positive feedback) submitted during the
     * indicated period. Returned if no detail level is specified.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FeedbackPeriodType[]
     */
    public $FeedbackPeriod;
    /**
     * Constructor method for FeedbackPeriodArrayType
     * @uses FeedbackPeriodArrayType::setFeedbackPeriod()
     * @param \StructType\FeedbackPeriodType[] $feedbackPeriod
     */
    public function __construct(array $feedbackPeriod = array())
    {
        $this
            ->setFeedbackPeriod($feedbackPeriod);
    }
    /**
     * Get FeedbackPeriod value
     * @return \StructType\FeedbackPeriodType[]|null
     */
    public function getFeedbackPeriod()
    {
        return $this->FeedbackPeriod;
    }
    /**
     * Set FeedbackPeriod value
     * @throws \InvalidArgumentException
     * @param \StructType\FeedbackPeriodType[] $feedbackPeriod
     * @return \ArrayType\FeedbackPeriodArrayType
     */
    public function setFeedbackPeriod(array $feedbackPeriod = array())
    {
        foreach ($feedbackPeriod as $feedbackPeriodArrayTypeFeedbackPeriodItem) {
            // validation for constraint: itemType
            if (!$feedbackPeriodArrayTypeFeedbackPeriodItem instanceof \StructType\FeedbackPeriodType) {
                throw new \InvalidArgumentException(sprintf('The FeedbackPeriod property can only contain items of \StructType\FeedbackPeriodType, "%s" given', is_object($feedbackPeriodArrayTypeFeedbackPeriodItem) ? get_class($feedbackPeriodArrayTypeFeedbackPeriodItem) : gettype($feedbackPeriodArrayTypeFeedbackPeriodItem)), __LINE__);
            }
        }
        $this->FeedbackPeriod = $feedbackPeriod;
        return $this;
    }
    /**
     * Add item to FeedbackPeriod value
     * @throws \InvalidArgumentException
     * @param \StructType\FeedbackPeriodType $item
     * @return \ArrayType\FeedbackPeriodArrayType
     */
    public function addToFeedbackPeriod(\StructType\FeedbackPeriodType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FeedbackPeriodType) {
            throw new \InvalidArgumentException(sprintf('The FeedbackPeriod property can only contain items of \StructType\FeedbackPeriodType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FeedbackPeriod[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\FeedbackPeriodType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\FeedbackPeriodType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\FeedbackPeriodType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\FeedbackPeriodType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\FeedbackPeriodType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FeedbackPeriod
     */
    public function getAttributeName()
    {
        return 'FeedbackPeriod';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\FeedbackPeriodArrayType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
