<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegulatoryType StructType
 * Meta information extracted from the WSDL
 * - documentation: Type defining the regulatory containers that are used at the listing level to provide Energy Efficiency Label information, hazardous material related information, product safety related information, manufacturer and responsible
 * person information, and the repair score.
 * @subpackage Structs
 */
class RegulatoryType extends AbstractStructBase
{
    /**
     * The EnergyEfficiencyLabel
     * Meta information extracted from the WSDL
     * - documentation: This container provides information about the energy efficiency for certain durable goods.<br /> <span class="tablenote"><b>Note: </b> As a part of Digital Services Act (DSA) requirements, all sellers who list products in Germany
     * (DE) must provide Energy Efficiency Label information and Product Information Sheets for listings for certain durable goods.</span> <span class="tablenote"><b>Note: </b> Energy efficiency information is not required for all categories. Use the <a
     * href = "/api-docs/sell/metadata/resources/marketplace/methods/getRegulatoryPolicies" target="_blank">getRegulatoryPolicies</a> method of the <a href="https://developer.ebay.com/api-docs/sell/metadata/resources/methods">Metadata API</a> to return
     * metadata on the eBay categories that recommend or require energy efficiency-related fields. </span>
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EnergyEfficiencyType
     */
    public $EnergyEfficiencyLabel;
    /**
     * The EconomicOperator
     * Meta information extracted from the WSDL
     * - documentation: <span class="tablenote"><b>Note: </b> Economic Operator is being decommissioned and being replaced by the <b>Manufacturer</b> and <b>ResponsiblePersons</b> containers. Economic Operator related fields should no longer be used for the
     * Add/Revise/Relist and VerifyItem family of calls. As it is currently still supported, Economic Operator-related fields will be returned if applicable for the GetItem call. </span> This container provides Economic Operator (EO) information about the
     * manufacturer and/or supplier of the item. The EO is a corporate entity that is related to, has some responsibility for, the product being listed for sale. For additional information, see <a href =
     * "https://www.ebay.com/help/selling/selling/CE-mark-EU?id=5225#operator" target="_blank">What is an economic operator?</a>.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EconomicOperatorType
     */
    public $EconomicOperator;
    /**
     * The Hazmat
     * Meta information extracted from the WSDL
     * - documentation: This container is used by the seller to provide hazardous material information for the listing. Three elements are required to complete the Hazmat section of a listing: <b>Pictograms</b>, <b>SignalWord</b>, and <b>Statements</b>. The
     * fourth element, <b>Component</b>, is optional. For more information, see <a href=" /api-docs/sell/static/metadata/feature-regulatorhazmatcontainer.html" target="_blank">Specifying hazardous material related information</a>. <br /> <span
     * class="tablenote"><b>Note: </b> Hazmat information is not required for all categories. Use the <a href = "/api-docs/sell/metadata/resources/marketplace/methods/getRegulatoryPolicies" target="_blank">getRegulatoryPolicies</a> method of the <a
     * href="https://developer.ebay.com/api-docs/sell/metadata/resources/methods">Metadata API</a> to return metadata on the eBay categories that recommend or require Hazmat-related fields. </span>
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\HazmatType
     */
    public $Hazmat;
    /**
     * The ProductSafety
     * Meta information extracted from the WSDL
     * - documentation: This container is used to provide product safety information for the listing. Two elements are required to complete the product safety section for a listing: <b>Pictograms</b> and <b>Statements</b>. The <b>Component</b> element is
     * optional. <br /> <br /> <b>For Revise and Relist calls:</b> To delete all product safety information when you revise or relist, specify <b>Item.Regulatory.ProductSafety</b> in <b>DeletedField</b>, and don't pass <b>ProductSafety</b> in the request.
     * <br /> <span class="tablenote"><b>Note: </b> As a part of General Product Safety Regulation (GPSR) requirements effective on December 13th, 2024, sellers operating in, or shipping to, EU-based countries or Northern Ireland are conditionally required
     * to provide product manufacturer information in their eBay listings. Product safety information is not required for all categories. Use the <a href = "/api-docs/sell/metadata/resources/marketplace/methods/getRegulatoryPolicies"
     * target="_blank">getRegulatoryPolicies</a> method of the <a href="https://developer.ebay.com/api-docs/sell/metadata/resources/methods">Metadata API</a> to return metadata on the eBay categories that recommend or require product safety-related fields.
     * For more information on GPSR, see <a href = "https://www.ebay.com/sellercenter/resources/general-product-safety-regulation" target="_blank">General Product Safety Regulation (GPSR)</a>.</span>
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ProductSafetyType
     */
    public $ProductSafety;
    /**
     * The RepairScore
     * Meta information extracted from the WSDL
     * - documentation: This field represents the repair index for the listing.<br><br>The repair index identifies the manufacturer's repair score for a product (how easy is it to repair the product). This field is a floating point value between 0 and 10
     * but may only have one digit beyond the decimal point, for example: <code>7.9</code><br><span class="tablenote"><b>Note: </b><code>0</code> should not be used as a default value, as it implies that the product is not repairable.</span>
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $RepairScore;
    /**
     * The Manufacturer
     * Meta information extracted from the WSDL
     * - documentation: This container provides information about the manufacturer of the item. <br /><br /> <b>For Revise and Relist calls:</b> To delete all manufacturer information when you revise or relist, specify <b>Item.Regulatory.Manufacturer</b> in
     * <b>DeletedField</b>, and don't pass <b>Manufacturer</b> in the request. <br /> <span class="tablenote"><b>Note: </b> As a part of General Product Safety Regulation (GPSR) requirements effective on December 13th, 2024, sellers operating in, or
     * shipping to, EU-based countries or Northern Ireland are conditionally required to provide product manufacturer information in their eBay listings. Manufacturer information is not required for all categories. Use the <a href =
     * "/api-docs/sell/metadata/resources/marketplace/methods/getRegulatoryPolicies" target="_blank">getRegulatoryPolicies</a> method of the <a href="https://developer.ebay.com/api-docs/sell/metadata/resources/methods">Metadata API</a> to return metadata on
     * the eBay categories that recommend or require manufacturer-related fields. For more information on GPSR, see <a href = "https://www.ebay.com/sellercenter/resources/general-product-safety-regulation" target="_blank">General Product Safety Regulation
     * (GPSR)</a>.</span>
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ManufacturerType
     */
    public $Manufacturer;
    /**
     * The ResponsiblePersons
     * Meta information extracted from the WSDL
     * - documentation: This container provides information about the EU-based Responsible Persons or entities associated with the listing. <br /><br /> <b>For Revise and Relist calls:</b> To delete all Responsible Persons information when you revise or
     * relist, specify <b>Item.Regulatory.ResponsiblePersons</b> in <b>DeletedField</b>, and don't pass <b>ResponsiblePersons</b> in the request. <br /> <span class="tablenote"><b>Note: </b> As a part of General Product Safety Regulation (GPSR) requirements
     * effective on December 13th, 2024, sellers operating in, or shipping to, EU-based countries or Northern Ireland are conditionally required to provide Responsible Persons information in their eBay listings if the manufacture is not based in the EU. For
     * more information on GPSR, see <a href = "https://www.ebay.com/sellercenter/resources/general-product-safety-regulation" target="_blank">General Product Safety Regulation (GPSR)</a>.</span>
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ResponsiblePersonsType
     */
    public $ResponsiblePersons;
    /**
     * The Documents
     * Meta information extracted from the WSDL
     * - documentation: This container provides a collection of regulatory documents associated with the listing. <br /><br /> <b>For Revise and Relist calls:</b> For information on removing one or more files using a Revise/Relist call, see <a href=
     * "/api-docs/sell/static/inventory/managing-document-media.html#revise" target="_blank">Remove documents from listings.</a> <br /> <span class="tablenote"><b>Note: </b> As a part of General Product Safety Regulation (GPSR) requirements effective on
     * December 13th, 2024, sellers operating in, or shipping to, EU-based countries or Northern Ireland are conditionally required to provide regulatory document information in their eBay listings. For more information on GPSR, see <a href =
     * "https://www.ebay.com/sellercenter/resources/general-product-safety-regulation" target="_blank">General Product Safety Regulation (GPSR)</a>.</span>
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DocumentsType
     */
    public $Documents;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for RegulatoryType
     * @uses RegulatoryType::setEnergyEfficiencyLabel()
     * @uses RegulatoryType::setEconomicOperator()
     * @uses RegulatoryType::setHazmat()
     * @uses RegulatoryType::setProductSafety()
     * @uses RegulatoryType::setRepairScore()
     * @uses RegulatoryType::setManufacturer()
     * @uses RegulatoryType::setResponsiblePersons()
     * @uses RegulatoryType::setDocuments()
     * @uses RegulatoryType::setAny()
     * @param \StructType\EnergyEfficiencyType $energyEfficiencyLabel
     * @param \StructType\EconomicOperatorType $economicOperator
     * @param \StructType\HazmatType $hazmat
     * @param \StructType\ProductSafetyType $productSafety
     * @param float $repairScore
     * @param \StructType\ManufacturerType $manufacturer
     * @param \StructType\ResponsiblePersonsType $responsiblePersons
     * @param \StructType\DocumentsType $documents
     * @param \DOMDocument $any
     */
    public function __construct(\StructType\EnergyEfficiencyType $energyEfficiencyLabel = null, \StructType\EconomicOperatorType $economicOperator = null, \StructType\HazmatType $hazmat = null, \StructType\ProductSafetyType $productSafety = null, $repairScore = null, \StructType\ManufacturerType $manufacturer = null, \StructType\ResponsiblePersonsType $responsiblePersons = null, \StructType\DocumentsType $documents = null, \DOMDocument $any = null)
    {
        $this
            ->setEnergyEfficiencyLabel($energyEfficiencyLabel)
            ->setEconomicOperator($economicOperator)
            ->setHazmat($hazmat)
            ->setProductSafety($productSafety)
            ->setRepairScore($repairScore)
            ->setManufacturer($manufacturer)
            ->setResponsiblePersons($responsiblePersons)
            ->setDocuments($documents)
            ->setAny($any);
    }
    /**
     * Get EnergyEfficiencyLabel value
     * @return \StructType\EnergyEfficiencyType|null
     */
    public function getEnergyEfficiencyLabel()
    {
        return $this->EnergyEfficiencyLabel;
    }
    /**
     * Set EnergyEfficiencyLabel value
     * @param \StructType\EnergyEfficiencyType $energyEfficiencyLabel
     * @return \StructType\RegulatoryType
     */
    public function setEnergyEfficiencyLabel(\StructType\EnergyEfficiencyType $energyEfficiencyLabel = null)
    {
        $this->EnergyEfficiencyLabel = $energyEfficiencyLabel;
        return $this;
    }
    /**
     * Get EconomicOperator value
     * @return \StructType\EconomicOperatorType|null
     */
    public function getEconomicOperator()
    {
        return $this->EconomicOperator;
    }
    /**
     * Set EconomicOperator value
     * @param \StructType\EconomicOperatorType $economicOperator
     * @return \StructType\RegulatoryType
     */
    public function setEconomicOperator(\StructType\EconomicOperatorType $economicOperator = null)
    {
        $this->EconomicOperator = $economicOperator;
        return $this;
    }
    /**
     * Get Hazmat value
     * @return \StructType\HazmatType|null
     */
    public function getHazmat()
    {
        return $this->Hazmat;
    }
    /**
     * Set Hazmat value
     * @param \StructType\HazmatType $hazmat
     * @return \StructType\RegulatoryType
     */
    public function setHazmat(\StructType\HazmatType $hazmat = null)
    {
        $this->Hazmat = $hazmat;
        return $this;
    }
    /**
     * Get ProductSafety value
     * @return \StructType\ProductSafetyType|null
     */
    public function getProductSafety()
    {
        return $this->ProductSafety;
    }
    /**
     * Set ProductSafety value
     * @param \StructType\ProductSafetyType $productSafety
     * @return \StructType\RegulatoryType
     */
    public function setProductSafety(\StructType\ProductSafetyType $productSafety = null)
    {
        $this->ProductSafety = $productSafety;
        return $this;
    }
    /**
     * Get RepairScore value
     * @return float|null
     */
    public function getRepairScore()
    {
        return $this->RepairScore;
    }
    /**
     * Set RepairScore value
     * @param float $repairScore
     * @return \StructType\RegulatoryType
     */
    public function setRepairScore($repairScore = null)
    {
        // validation for constraint: float
        if (!is_null($repairScore) && !(is_float($repairScore) || is_numeric($repairScore))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($repairScore, true), gettype($repairScore)), __LINE__);
        }
        $this->RepairScore = $repairScore;
        return $this;
    }
    /**
     * Get Manufacturer value
     * @return \StructType\ManufacturerType|null
     */
    public function getManufacturer()
    {
        return $this->Manufacturer;
    }
    /**
     * Set Manufacturer value
     * @param \StructType\ManufacturerType $manufacturer
     * @return \StructType\RegulatoryType
     */
    public function setManufacturer(\StructType\ManufacturerType $manufacturer = null)
    {
        $this->Manufacturer = $manufacturer;
        return $this;
    }
    /**
     * Get ResponsiblePersons value
     * @return \StructType\ResponsiblePersonsType|null
     */
    public function getResponsiblePersons()
    {
        return $this->ResponsiblePersons;
    }
    /**
     * Set ResponsiblePersons value
     * @param \StructType\ResponsiblePersonsType $responsiblePersons
     * @return \StructType\RegulatoryType
     */
    public function setResponsiblePersons(\StructType\ResponsiblePersonsType $responsiblePersons = null)
    {
        $this->ResponsiblePersons = $responsiblePersons;
        return $this;
    }
    /**
     * Get Documents value
     * @return \StructType\DocumentsType|null
     */
    public function getDocuments()
    {
        return $this->Documents;
    }
    /**
     * Set Documents value
     * @param \StructType\DocumentsType $documents
     * @return \StructType\RegulatoryType
     */
    public function setDocuments(\StructType\DocumentsType $documents = null)
    {
        $this->Documents = $documents;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \StructType\RegulatoryType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
