<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShippingStatus StructType
 * @subpackage Structs
 */
class ShippingStatus extends AbstractStructBase
{
    /**
     * The shippingId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $shippingId;
    /**
     * The statusText
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $statusText;
    /**
     * The statusDateTime
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $statusDateTime;
    /**
     * Constructor method for ShippingStatus
     * @uses ShippingStatus::setShippingId()
     * @uses ShippingStatus::setStatusText()
     * @uses ShippingStatus::setStatusDateTime()
     * @param string $shippingId
     * @param string $statusText
     * @param string $statusDateTime
     */
    public function __construct($shippingId = null, $statusText = null, $statusDateTime = null)
    {
        $this
            ->setShippingId($shippingId)
            ->setStatusText($statusText)
            ->setStatusDateTime($statusDateTime);
    }
    /**
     * Get shippingId value
     * @return string|null
     */
    public function getShippingId()
    {
        return $this->shippingId;
    }
    /**
     * Set shippingId value
     * @param string $shippingId
     * @return \StructType\ShippingStatus
     */
    public function setShippingId($shippingId = null)
    {
        // validation for constraint: string
        if (!is_null($shippingId) && !is_string($shippingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shippingId)), __LINE__);
        }
        $this->shippingId = $shippingId;
        return $this;
    }
    /**
     * Get statusText value
     * @return string|null
     */
    public function getStatusText()
    {
        return $this->statusText;
    }
    /**
     * Set statusText value
     * @param string $statusText
     * @return \StructType\ShippingStatus
     */
    public function setStatusText($statusText = null)
    {
        // validation for constraint: string
        if (!is_null($statusText) && !is_string($statusText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusText)), __LINE__);
        }
        $this->statusText = $statusText;
        return $this;
    }
    /**
     * Get statusDateTime value
     * @return string|null
     */
    public function getStatusDateTime()
    {
        return $this->statusDateTime;
    }
    /**
     * Set statusDateTime value
     * @param string $statusDateTime
     * @return \StructType\ShippingStatus
     */
    public function setStatusDateTime($statusDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($statusDateTime) && !is_string($statusDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusDateTime)), __LINE__);
        }
        $this->statusDateTime = $statusDateTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShippingStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
