<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropsOrderShort StructType
 * @subpackage Structs
 */
class PropsOrderShort extends AbstractStructBase
{
    /**
     * The orderNo
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $orderNo;
    /**
     * The shippingId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $shippingId;
    /**
     * The creationDate
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $creationDate;
    /**
     * The parcelClass
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $parcelClass;
    /**
     * The status_text
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $status_text;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $status;
    /**
     * The firstname
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $firstname;
    /**
     * The lastname
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $lastname;
    /**
     * The postcode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $postcode;
    /**
     * The city
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $city;
    /**
     * The countryCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $countryCode;
    /**
     * The bulkGoodsServiceAmount
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $bulkGoodsServiceAmount;
    /**
     * Constructor method for PropsOrderShort
     * @uses PropsOrderShort::setOrderNo()
     * @uses PropsOrderShort::setShippingId()
     * @uses PropsOrderShort::setCreationDate()
     * @uses PropsOrderShort::setParcelClass()
     * @uses PropsOrderShort::setStatus_text()
     * @uses PropsOrderShort::setStatus()
     * @uses PropsOrderShort::setFirstname()
     * @uses PropsOrderShort::setLastname()
     * @uses PropsOrderShort::setPostcode()
     * @uses PropsOrderShort::setCity()
     * @uses PropsOrderShort::setCountryCode()
     * @uses PropsOrderShort::setBulkGoodsServiceAmount()
     * @param string $orderNo
     * @param string $shippingId
     * @param string $creationDate
     * @param string $parcelClass
     * @param string $status_text
     * @param int $status
     * @param string $firstname
     * @param string $lastname
     * @param string $postcode
     * @param string $city
     * @param string $countryCode
     * @param int $bulkGoodsServiceAmount
     */
    public function __construct($orderNo = null, $shippingId = null, $creationDate = null, $parcelClass = null, $status_text = null, $status = null, $firstname = null, $lastname = null, $postcode = null, $city = null, $countryCode = null, $bulkGoodsServiceAmount = null)
    {
        $this
            ->setOrderNo($orderNo)
            ->setShippingId($shippingId)
            ->setCreationDate($creationDate)
            ->setParcelClass($parcelClass)
            ->setStatus_text($status_text)
            ->setStatus($status)
            ->setFirstname($firstname)
            ->setLastname($lastname)
            ->setPostcode($postcode)
            ->setCity($city)
            ->setCountryCode($countryCode)
            ->setBulkGoodsServiceAmount($bulkGoodsServiceAmount);
    }
    /**
     * Get orderNo value
     * @return string|null
     */
    public function getOrderNo()
    {
        return $this->orderNo;
    }
    /**
     * Set orderNo value
     * @param string $orderNo
     * @return \StructType\PropsOrderShort
     */
    public function setOrderNo($orderNo = null)
    {
        // validation for constraint: string
        if (!is_null($orderNo) && !is_string($orderNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderNo)), __LINE__);
        }
        $this->orderNo = $orderNo;
        return $this;
    }
    /**
     * Get shippingId value
     * @return string|null
     */
    public function getShippingId()
    {
        return $this->shippingId;
    }
    /**
     * Set shippingId value
     * @param string $shippingId
     * @return \StructType\PropsOrderShort
     */
    public function setShippingId($shippingId = null)
    {
        // validation for constraint: string
        if (!is_null($shippingId) && !is_string($shippingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shippingId)), __LINE__);
        }
        $this->shippingId = $shippingId;
        return $this;
    }
    /**
     * Get creationDate value
     * @return string|null
     */
    public function getCreationDate()
    {
        return $this->creationDate;
    }
    /**
     * Set creationDate value
     * @param string $creationDate
     * @return \StructType\PropsOrderShort
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creationDate)), __LINE__);
        }
        $this->creationDate = $creationDate;
        return $this;
    }
    /**
     * Get parcelClass value
     * @return string|null
     */
    public function getParcelClass()
    {
        return $this->parcelClass;
    }
    /**
     * Set parcelClass value
     * @param string $parcelClass
     * @return \StructType\PropsOrderShort
     */
    public function setParcelClass($parcelClass = null)
    {
        // validation for constraint: string
        if (!is_null($parcelClass) && !is_string($parcelClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parcelClass)), __LINE__);
        }
        $this->parcelClass = $parcelClass;
        return $this;
    }
    /**
     * Get status_text value
     * @return string|null
     */
    public function getStatus_text()
    {
        return $this->status_text;
    }
    /**
     * Set status_text value
     * @param string $status_text
     * @return \StructType\PropsOrderShort
     */
    public function setStatus_text($status_text = null)
    {
        // validation for constraint: string
        if (!is_null($status_text) && !is_string($status_text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status_text)), __LINE__);
        }
        $this->status_text = $status_text;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \StructType\PropsOrderShort
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !is_numeric($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get firstname value
     * @return string|null
     */
    public function getFirstname()
    {
        return $this->firstname;
    }
    /**
     * Set firstname value
     * @param string $firstname
     * @return \StructType\PropsOrderShort
     */
    public function setFirstname($firstname = null)
    {
        // validation for constraint: string
        if (!is_null($firstname) && !is_string($firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstname)), __LINE__);
        }
        $this->firstname = $firstname;
        return $this;
    }
    /**
     * Get lastname value
     * @return string|null
     */
    public function getLastname()
    {
        return $this->lastname;
    }
    /**
     * Set lastname value
     * @param string $lastname
     * @return \StructType\PropsOrderShort
     */
    public function setLastname($lastname = null)
    {
        // validation for constraint: string
        if (!is_null($lastname) && !is_string($lastname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastname)), __LINE__);
        }
        $this->lastname = $lastname;
        return $this;
    }
    /**
     * Get postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \StructType\PropsOrderShort
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\PropsOrderShort
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get countryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return \StructType\PropsOrderShort
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Get bulkGoodsServiceAmount value
     * @return int|null
     */
    public function getBulkGoodsServiceAmount()
    {
        return $this->bulkGoodsServiceAmount;
    }
    /**
     * Set bulkGoodsServiceAmount value
     * @param int $bulkGoodsServiceAmount
     * @return \StructType\PropsOrderShort
     */
    public function setBulkGoodsServiceAmount($bulkGoodsServiceAmount = null)
    {
        // validation for constraint: int
        if (!is_null($bulkGoodsServiceAmount) && !is_numeric($bulkGoodsServiceAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bulkGoodsServiceAmount)), __LINE__);
        }
        $this->bulkGoodsServiceAmount = $bulkGoodsServiceAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PropsOrderShort
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
