<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropsOrderLong StructType
 * @subpackage Structs
 */
class PropsOrderLong extends AbstractStructBase
{
    /**
     * The clientReferenceNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $clientReferenceNumber;
    /**
     * The ebayNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ebayNumber;
    /**
     * The shipper
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Address
     */
    public $shipper;
    /**
     * The amountCashOnDeliveryEurocent
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $amountCashOnDeliveryEurocent;
    /**
     * The trackingFlag
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $trackingFlag;
    /**
     * The orderNo
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $orderNo;
    /**
     * The shippingId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $shippingId;
    /**
     * The printDate
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $printDate;
    /**
     * The parcelClass
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $parcelClass;
    /**
     * The status_text
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $status_text;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $status;
    /**
     * The receiver
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Address
     */
    public $receiver;
    /**
     * Constructor method for PropsOrderLong
     * @uses PropsOrderLong::setClientReferenceNumber()
     * @uses PropsOrderLong::setEbayNumber()
     * @uses PropsOrderLong::setShipper()
     * @uses PropsOrderLong::setAmountCashOnDeliveryEurocent()
     * @uses PropsOrderLong::setTrackingFlag()
     * @uses PropsOrderLong::setOrderNo()
     * @uses PropsOrderLong::setShippingId()
     * @uses PropsOrderLong::setPrintDate()
     * @uses PropsOrderLong::setParcelClass()
     * @uses PropsOrderLong::setStatus_text()
     * @uses PropsOrderLong::setStatus()
     * @uses PropsOrderLong::setReceiver()
     * @param string $clientReferenceNumber
     * @param string $ebayNumber
     * @param \StructType\Address $shipper
     * @param int $amountCashOnDeliveryEurocent
     * @param int $trackingFlag
     * @param string $orderNo
     * @param string $shippingId
     * @param string $printDate
     * @param string $parcelClass
     * @param string $status_text
     * @param int $status
     * @param \StructType\Address $receiver
     */
    public function __construct($clientReferenceNumber = null, $ebayNumber = null, \StructType\Address $shipper = null, $amountCashOnDeliveryEurocent = null, $trackingFlag = null, $orderNo = null, $shippingId = null, $printDate = null, $parcelClass = null, $status_text = null, $status = null, \StructType\Address $receiver = null)
    {
        $this
            ->setClientReferenceNumber($clientReferenceNumber)
            ->setEbayNumber($ebayNumber)
            ->setShipper($shipper)
            ->setAmountCashOnDeliveryEurocent($amountCashOnDeliveryEurocent)
            ->setTrackingFlag($trackingFlag)
            ->setOrderNo($orderNo)
            ->setShippingId($shippingId)
            ->setPrintDate($printDate)
            ->setParcelClass($parcelClass)
            ->setStatus_text($status_text)
            ->setStatus($status)
            ->setReceiver($receiver);
    }
    /**
     * Get clientReferenceNumber value
     * @return string|null
     */
    public function getClientReferenceNumber()
    {
        return $this->clientReferenceNumber;
    }
    /**
     * Set clientReferenceNumber value
     * @param string $clientReferenceNumber
     * @return \StructType\PropsOrderLong
     */
    public function setClientReferenceNumber($clientReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($clientReferenceNumber) && !is_string($clientReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientReferenceNumber)), __LINE__);
        }
        $this->clientReferenceNumber = $clientReferenceNumber;
        return $this;
    }
    /**
     * Get ebayNumber value
     * @return string|null
     */
    public function getEbayNumber()
    {
        return $this->ebayNumber;
    }
    /**
     * Set ebayNumber value
     * @param string $ebayNumber
     * @return \StructType\PropsOrderLong
     */
    public function setEbayNumber($ebayNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ebayNumber) && !is_string($ebayNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ebayNumber)), __LINE__);
        }
        $this->ebayNumber = $ebayNumber;
        return $this;
    }
    /**
     * Get shipper value
     * @return \StructType\Address|null
     */
    public function getShipper()
    {
        return $this->shipper;
    }
    /**
     * Set shipper value
     * @param \StructType\Address $shipper
     * @return \StructType\PropsOrderLong
     */
    public function setShipper(\StructType\Address $shipper = null)
    {
        $this->shipper = $shipper;
        return $this;
    }
    /**
     * Get amountCashOnDeliveryEurocent value
     * @return int|null
     */
    public function getAmountCashOnDeliveryEurocent()
    {
        return $this->amountCashOnDeliveryEurocent;
    }
    /**
     * Set amountCashOnDeliveryEurocent value
     * @param int $amountCashOnDeliveryEurocent
     * @return \StructType\PropsOrderLong
     */
    public function setAmountCashOnDeliveryEurocent($amountCashOnDeliveryEurocent = null)
    {
        // validation for constraint: int
        if (!is_null($amountCashOnDeliveryEurocent) && !is_numeric($amountCashOnDeliveryEurocent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($amountCashOnDeliveryEurocent)), __LINE__);
        }
        $this->amountCashOnDeliveryEurocent = $amountCashOnDeliveryEurocent;
        return $this;
    }
    /**
     * Get trackingFlag value
     * @return int|null
     */
    public function getTrackingFlag()
    {
        return $this->trackingFlag;
    }
    /**
     * Set trackingFlag value
     * @param int $trackingFlag
     * @return \StructType\PropsOrderLong
     */
    public function setTrackingFlag($trackingFlag = null)
    {
        // validation for constraint: int
        if (!is_null($trackingFlag) && !is_numeric($trackingFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($trackingFlag)), __LINE__);
        }
        $this->trackingFlag = $trackingFlag;
        return $this;
    }
    /**
     * Get orderNo value
     * @return string|null
     */
    public function getOrderNo()
    {
        return $this->orderNo;
    }
    /**
     * Set orderNo value
     * @param string $orderNo
     * @return \StructType\PropsOrderLong
     */
    public function setOrderNo($orderNo = null)
    {
        // validation for constraint: string
        if (!is_null($orderNo) && !is_string($orderNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderNo)), __LINE__);
        }
        $this->orderNo = $orderNo;
        return $this;
    }
    /**
     * Get shippingId value
     * @return string|null
     */
    public function getShippingId()
    {
        return $this->shippingId;
    }
    /**
     * Set shippingId value
     * @param string $shippingId
     * @return \StructType\PropsOrderLong
     */
    public function setShippingId($shippingId = null)
    {
        // validation for constraint: string
        if (!is_null($shippingId) && !is_string($shippingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shippingId)), __LINE__);
        }
        $this->shippingId = $shippingId;
        return $this;
    }
    /**
     * Get printDate value
     * @return string|null
     */
    public function getPrintDate()
    {
        return $this->printDate;
    }
    /**
     * Set printDate value
     * @param string $printDate
     * @return \StructType\PropsOrderLong
     */
    public function setPrintDate($printDate = null)
    {
        // validation for constraint: string
        if (!is_null($printDate) && !is_string($printDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($printDate)), __LINE__);
        }
        $this->printDate = $printDate;
        return $this;
    }
    /**
     * Get parcelClass value
     * @return string|null
     */
    public function getParcelClass()
    {
        return $this->parcelClass;
    }
    /**
     * Set parcelClass value
     * @param string $parcelClass
     * @return \StructType\PropsOrderLong
     */
    public function setParcelClass($parcelClass = null)
    {
        // validation for constraint: string
        if (!is_null($parcelClass) && !is_string($parcelClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parcelClass)), __LINE__);
        }
        $this->parcelClass = $parcelClass;
        return $this;
    }
    /**
     * Get status_text value
     * @return string|null
     */
    public function getStatus_text()
    {
        return $this->status_text;
    }
    /**
     * Set status_text value
     * @param string $status_text
     * @return \StructType\PropsOrderLong
     */
    public function setStatus_text($status_text = null)
    {
        // validation for constraint: string
        if (!is_null($status_text) && !is_string($status_text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status_text)), __LINE__);
        }
        $this->status_text = $status_text;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \StructType\PropsOrderLong
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !is_numeric($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get receiver value
     * @return \StructType\Address|null
     */
    public function getReceiver()
    {
        return $this->receiver;
    }
    /**
     * Set receiver value
     * @param \StructType\Address $receiver
     * @return \StructType\PropsOrderLong
     */
    public function setReceiver(\StructType\Address $receiver = null)
    {
        $this->receiver = $receiver;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PropsOrderLong
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
