<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductWithPrice StructType
 * @subpackage Structs
 */
class ProductWithPrice extends AbstractStructBase
{
    /**
     * The netPriceEurcent
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $netPriceEurcent;
    /**
     * The validAt
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $validAt;
    /**
     * The productInfo
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\ProductInfo
     */
    public $productInfo;
    /**
     * Constructor method for ProductWithPrice
     * @uses ProductWithPrice::setNetPriceEurcent()
     * @uses ProductWithPrice::setValidAt()
     * @uses ProductWithPrice::setProductInfo()
     * @param int $netPriceEurcent
     * @param string $validAt
     * @param \StructType\ProductInfo $productInfo
     */
    public function __construct($netPriceEurcent = null, $validAt = null, \StructType\ProductInfo $productInfo = null)
    {
        $this
            ->setNetPriceEurcent($netPriceEurcent)
            ->setValidAt($validAt)
            ->setProductInfo($productInfo);
    }
    /**
     * Get netPriceEurcent value
     * @return int|null
     */
    public function getNetPriceEurcent()
    {
        return $this->netPriceEurcent;
    }
    /**
     * Set netPriceEurcent value
     * @param int $netPriceEurcent
     * @return \StructType\ProductWithPrice
     */
    public function setNetPriceEurcent($netPriceEurcent = null)
    {
        // validation for constraint: int
        if (!is_null($netPriceEurcent) && !is_numeric($netPriceEurcent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($netPriceEurcent)), __LINE__);
        }
        $this->netPriceEurcent = $netPriceEurcent;
        return $this;
    }
    /**
     * Get validAt value
     * @return string|null
     */
    public function getValidAt()
    {
        return $this->validAt;
    }
    /**
     * Set validAt value
     * @param string $validAt
     * @return \StructType\ProductWithPrice
     */
    public function setValidAt($validAt = null)
    {
        // validation for constraint: string
        if (!is_null($validAt) && !is_string($validAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($validAt)), __LINE__);
        }
        $this->validAt = $validAt;
        return $this;
    }
    /**
     * Get productInfo value
     * @return \StructType\ProductInfo|null
     */
    public function getProductInfo()
    {
        return $this->productInfo;
    }
    /**
     * Set productInfo value
     * @param \StructType\ProductInfo $productInfo
     * @return \StructType\ProductWithPrice
     */
    public function setProductInfo(\StructType\ProductInfo $productInfo = null)
    {
        $this->productInfo = $productInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductWithPrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
