<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListOfProducts StructType
 * @subpackage Structs
 */
class ListOfProducts extends AbstractStructBase
{
    /**
     * The numberOfProducts
     * @var int
     */
    public $numberOfProducts;
    /**
     * The products
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfProductWithPrice
     */
    public $products;
    /**
     * The dated
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $dated;
    /**
     * The labelAcceptanceTermsAndConditions
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $labelAcceptanceTermsAndConditions;
    /**
     * The labelAcceptanceLiabilityLimit
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $labelAcceptanceLiabilityLimit;
    /**
     * The urlTermsAndConditions
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $urlTermsAndConditions;
    /**
     * The netPriceCashOnDeliveryEurocent
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $netPriceCashOnDeliveryEurocent;
    /**
     * The settlementType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $settlementType;
    /**
     * The urlHermesLogogram
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $urlHermesLogogram;
    /**
     * The urlLiabilityInformations
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $urlLiabilityInformations;
    /**
     * The urlPackagingGuidelines
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $urlPackagingGuidelines;
    /**
     * The urlPortalB2C
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $urlPortalB2C;
    /**
     * The vatInfo
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $vatInfo;
    /**
     * The serviceChargeList
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfServiceCharge
     */
    public $serviceChargeList;
    /**
     * Constructor method for ListOfProducts
     * @uses ListOfProducts::setNumberOfProducts()
     * @uses ListOfProducts::setProducts()
     * @uses ListOfProducts::setDated()
     * @uses ListOfProducts::setLabelAcceptanceTermsAndConditions()
     * @uses ListOfProducts::setLabelAcceptanceLiabilityLimit()
     * @uses ListOfProducts::setUrlTermsAndConditions()
     * @uses ListOfProducts::setNetPriceCashOnDeliveryEurocent()
     * @uses ListOfProducts::setSettlementType()
     * @uses ListOfProducts::setUrlHermesLogogram()
     * @uses ListOfProducts::setUrlLiabilityInformations()
     * @uses ListOfProducts::setUrlPackagingGuidelines()
     * @uses ListOfProducts::setUrlPortalB2C()
     * @uses ListOfProducts::setVatInfo()
     * @uses ListOfProducts::setServiceChargeList()
     * @param int $numberOfProducts
     * @param \ArrayType\ArrayOfProductWithPrice $products
     * @param string $dated
     * @param string $labelAcceptanceTermsAndConditions
     * @param string $labelAcceptanceLiabilityLimit
     * @param string $urlTermsAndConditions
     * @param int $netPriceCashOnDeliveryEurocent
     * @param string $settlementType
     * @param string $urlHermesLogogram
     * @param string $urlLiabilityInformations
     * @param string $urlPackagingGuidelines
     * @param string $urlPortalB2C
     * @param string $vatInfo
     * @param \ArrayType\ArrayOfServiceCharge $serviceChargeList
     */
    public function __construct($numberOfProducts = null, \ArrayType\ArrayOfProductWithPrice $products = null, $dated = null, $labelAcceptanceTermsAndConditions = null, $labelAcceptanceLiabilityLimit = null, $urlTermsAndConditions = null, $netPriceCashOnDeliveryEurocent = null, $settlementType = null, $urlHermesLogogram = null, $urlLiabilityInformations = null, $urlPackagingGuidelines = null, $urlPortalB2C = null, $vatInfo = null, \ArrayType\ArrayOfServiceCharge $serviceChargeList = null)
    {
        $this
            ->setNumberOfProducts($numberOfProducts)
            ->setProducts($products)
            ->setDated($dated)
            ->setLabelAcceptanceTermsAndConditions($labelAcceptanceTermsAndConditions)
            ->setLabelAcceptanceLiabilityLimit($labelAcceptanceLiabilityLimit)
            ->setUrlTermsAndConditions($urlTermsAndConditions)
            ->setNetPriceCashOnDeliveryEurocent($netPriceCashOnDeliveryEurocent)
            ->setSettlementType($settlementType)
            ->setUrlHermesLogogram($urlHermesLogogram)
            ->setUrlLiabilityInformations($urlLiabilityInformations)
            ->setUrlPackagingGuidelines($urlPackagingGuidelines)
            ->setUrlPortalB2C($urlPortalB2C)
            ->setVatInfo($vatInfo)
            ->setServiceChargeList($serviceChargeList);
    }
    /**
     * Get numberOfProducts value
     * @return int|null
     */
    public function getNumberOfProducts()
    {
        return $this->numberOfProducts;
    }
    /**
     * Set numberOfProducts value
     * @param int $numberOfProducts
     * @return \StructType\ListOfProducts
     */
    public function setNumberOfProducts($numberOfProducts = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfProducts) && !is_numeric($numberOfProducts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfProducts)), __LINE__);
        }
        $this->numberOfProducts = $numberOfProducts;
        return $this;
    }
    /**
     * Get products value
     * @return \ArrayType\ArrayOfProductWithPrice|null
     */
    public function getProducts()
    {
        return $this->products;
    }
    /**
     * Set products value
     * @param \ArrayType\ArrayOfProductWithPrice $products
     * @return \StructType\ListOfProducts
     */
    public function setProducts(\ArrayType\ArrayOfProductWithPrice $products = null)
    {
        $this->products = $products;
        return $this;
    }
    /**
     * Get dated value
     * @return string|null
     */
    public function getDated()
    {
        return $this->dated;
    }
    /**
     * Set dated value
     * @param string $dated
     * @return \StructType\ListOfProducts
     */
    public function setDated($dated = null)
    {
        // validation for constraint: string
        if (!is_null($dated) && !is_string($dated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dated)), __LINE__);
        }
        $this->dated = $dated;
        return $this;
    }
    /**
     * Get labelAcceptanceTermsAndConditions value
     * @return string|null
     */
    public function getLabelAcceptanceTermsAndConditions()
    {
        return $this->labelAcceptanceTermsAndConditions;
    }
    /**
     * Set labelAcceptanceTermsAndConditions value
     * @param string $labelAcceptanceTermsAndConditions
     * @return \StructType\ListOfProducts
     */
    public function setLabelAcceptanceTermsAndConditions($labelAcceptanceTermsAndConditions = null)
    {
        // validation for constraint: string
        if (!is_null($labelAcceptanceTermsAndConditions) && !is_string($labelAcceptanceTermsAndConditions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($labelAcceptanceTermsAndConditions)), __LINE__);
        }
        $this->labelAcceptanceTermsAndConditions = $labelAcceptanceTermsAndConditions;
        return $this;
    }
    /**
     * Get labelAcceptanceLiabilityLimit value
     * @return string|null
     */
    public function getLabelAcceptanceLiabilityLimit()
    {
        return $this->labelAcceptanceLiabilityLimit;
    }
    /**
     * Set labelAcceptanceLiabilityLimit value
     * @param string $labelAcceptanceLiabilityLimit
     * @return \StructType\ListOfProducts
     */
    public function setLabelAcceptanceLiabilityLimit($labelAcceptanceLiabilityLimit = null)
    {
        // validation for constraint: string
        if (!is_null($labelAcceptanceLiabilityLimit) && !is_string($labelAcceptanceLiabilityLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($labelAcceptanceLiabilityLimit)), __LINE__);
        }
        $this->labelAcceptanceLiabilityLimit = $labelAcceptanceLiabilityLimit;
        return $this;
    }
    /**
     * Get urlTermsAndConditions value
     * @return string|null
     */
    public function getUrlTermsAndConditions()
    {
        return $this->urlTermsAndConditions;
    }
    /**
     * Set urlTermsAndConditions value
     * @param string $urlTermsAndConditions
     * @return \StructType\ListOfProducts
     */
    public function setUrlTermsAndConditions($urlTermsAndConditions = null)
    {
        // validation for constraint: string
        if (!is_null($urlTermsAndConditions) && !is_string($urlTermsAndConditions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($urlTermsAndConditions)), __LINE__);
        }
        $this->urlTermsAndConditions = $urlTermsAndConditions;
        return $this;
    }
    /**
     * Get netPriceCashOnDeliveryEurocent value
     * @return int|null
     */
    public function getNetPriceCashOnDeliveryEurocent()
    {
        return $this->netPriceCashOnDeliveryEurocent;
    }
    /**
     * Set netPriceCashOnDeliveryEurocent value
     * @param int $netPriceCashOnDeliveryEurocent
     * @return \StructType\ListOfProducts
     */
    public function setNetPriceCashOnDeliveryEurocent($netPriceCashOnDeliveryEurocent = null)
    {
        // validation for constraint: int
        if (!is_null($netPriceCashOnDeliveryEurocent) && !is_numeric($netPriceCashOnDeliveryEurocent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($netPriceCashOnDeliveryEurocent)), __LINE__);
        }
        $this->netPriceCashOnDeliveryEurocent = $netPriceCashOnDeliveryEurocent;
        return $this;
    }
    /**
     * Get settlementType value
     * @return string|null
     */
    public function getSettlementType()
    {
        return $this->settlementType;
    }
    /**
     * Set settlementType value
     * @param string $settlementType
     * @return \StructType\ListOfProducts
     */
    public function setSettlementType($settlementType = null)
    {
        // validation for constraint: string
        if (!is_null($settlementType) && !is_string($settlementType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($settlementType)), __LINE__);
        }
        $this->settlementType = $settlementType;
        return $this;
    }
    /**
     * Get urlHermesLogogram value
     * @return string|null
     */
    public function getUrlHermesLogogram()
    {
        return $this->urlHermesLogogram;
    }
    /**
     * Set urlHermesLogogram value
     * @param string $urlHermesLogogram
     * @return \StructType\ListOfProducts
     */
    public function setUrlHermesLogogram($urlHermesLogogram = null)
    {
        // validation for constraint: string
        if (!is_null($urlHermesLogogram) && !is_string($urlHermesLogogram)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($urlHermesLogogram)), __LINE__);
        }
        $this->urlHermesLogogram = $urlHermesLogogram;
        return $this;
    }
    /**
     * Get urlLiabilityInformations value
     * @return string|null
     */
    public function getUrlLiabilityInformations()
    {
        return $this->urlLiabilityInformations;
    }
    /**
     * Set urlLiabilityInformations value
     * @param string $urlLiabilityInformations
     * @return \StructType\ListOfProducts
     */
    public function setUrlLiabilityInformations($urlLiabilityInformations = null)
    {
        // validation for constraint: string
        if (!is_null($urlLiabilityInformations) && !is_string($urlLiabilityInformations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($urlLiabilityInformations)), __LINE__);
        }
        $this->urlLiabilityInformations = $urlLiabilityInformations;
        return $this;
    }
    /**
     * Get urlPackagingGuidelines value
     * @return string|null
     */
    public function getUrlPackagingGuidelines()
    {
        return $this->urlPackagingGuidelines;
    }
    /**
     * Set urlPackagingGuidelines value
     * @param string $urlPackagingGuidelines
     * @return \StructType\ListOfProducts
     */
    public function setUrlPackagingGuidelines($urlPackagingGuidelines = null)
    {
        // validation for constraint: string
        if (!is_null($urlPackagingGuidelines) && !is_string($urlPackagingGuidelines)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($urlPackagingGuidelines)), __LINE__);
        }
        $this->urlPackagingGuidelines = $urlPackagingGuidelines;
        return $this;
    }
    /**
     * Get urlPortalB2C value
     * @return string|null
     */
    public function getUrlPortalB2C()
    {
        return $this->urlPortalB2C;
    }
    /**
     * Set urlPortalB2C value
     * @param string $urlPortalB2C
     * @return \StructType\ListOfProducts
     */
    public function setUrlPortalB2C($urlPortalB2C = null)
    {
        // validation for constraint: string
        if (!is_null($urlPortalB2C) && !is_string($urlPortalB2C)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($urlPortalB2C)), __LINE__);
        }
        $this->urlPortalB2C = $urlPortalB2C;
        return $this;
    }
    /**
     * Get vatInfo value
     * @return string|null
     */
    public function getVatInfo()
    {
        return $this->vatInfo;
    }
    /**
     * Set vatInfo value
     * @param string $vatInfo
     * @return \StructType\ListOfProducts
     */
    public function setVatInfo($vatInfo = null)
    {
        // validation for constraint: string
        if (!is_null($vatInfo) && !is_string($vatInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vatInfo)), __LINE__);
        }
        $this->vatInfo = $vatInfo;
        return $this;
    }
    /**
     * Get serviceChargeList value
     * @return \ArrayType\ArrayOfServiceCharge|null
     */
    public function getServiceChargeList()
    {
        return $this->serviceChargeList;
    }
    /**
     * Set serviceChargeList value
     * @param \ArrayType\ArrayOfServiceCharge $serviceChargeList
     * @return \StructType\ListOfProducts
     */
    public function setServiceChargeList(\ArrayType\ArrayOfServiceCharge $serviceChargeList = null)
    {
        $this->serviceChargeList = $serviceChargeList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ListOfProducts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
