<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for exceptionObject StructType
 * @subpackage Structs
 */
class ExceptionObject extends AbstractStructBase
{
    /**
     * The errorMessage
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $errorMessage;
    /**
     * The errorCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $errorCode;
    /**
     * The errorType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $errorType;
    /**
     * Constructor method for exceptionObject
     * @uses ExceptionObject::setErrorMessage()
     * @uses ExceptionObject::setErrorCode()
     * @uses ExceptionObject::setErrorType()
     * @param string $errorMessage
     * @param int $errorCode
     * @param string $errorType
     */
    public function __construct($errorMessage = null, $errorCode = null, $errorType = null)
    {
        $this
            ->setErrorMessage($errorMessage)
            ->setErrorCode($errorCode)
            ->setErrorType($errorType);
    }
    /**
     * Get errorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->errorMessage;
    }
    /**
     * Set errorMessage value
     * @param string $errorMessage
     * @return \StructType\ExceptionObject
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorMessage)), __LINE__);
        }
        $this->errorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get errorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @param int $errorCode
     * @return \StructType\ExceptionObject
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !is_numeric($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($errorCode)), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get errorType value
     * @return string|null
     */
    public function getErrorType()
    {
        return $this->errorType;
    }
    /**
     * Set errorType value
     * @param string $errorType
     * @return \StructType\ExceptionObject
     */
    public function setErrorType($errorType = null)
    {
        // validation for constraint: string
        if (!is_null($errorType) && !is_string($errorType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorType)), __LINE__);
        }
        $this->errorType = $errorType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExceptionObject
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
