<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOf_tns4_nillable_ExceptionItem ArrayType
 * @subpackage Arrays
 */
class ArrayOf_tns4_nillable_ExceptionItem extends AbstractStructArrayBase
{
    /**
     * The ExceptionItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExceptionObject[]
     */
    public $ExceptionItem;
    /**
     * Constructor method for ArrayOf_tns4_nillable_ExceptionItem
     * @uses ArrayOf_tns4_nillable_ExceptionItem::setExceptionItem()
     * @param \StructType\ExceptionObject[] $exceptionItem
     */
    public function __construct(array $exceptionItem = array())
    {
        $this
            ->setExceptionItem($exceptionItem);
    }
    /**
     * Get ExceptionItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExceptionObject[]|null
     */
    public function getExceptionItem()
    {
        return isset($this->ExceptionItem) ? $this->ExceptionItem : null;
    }
    /**
     * Set ExceptionItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ExceptionObject[] $exceptionItem
     * @return \ArrayType\ArrayOf_tns4_nillable_ExceptionItem
     */
    public function setExceptionItem(array $exceptionItem = array())
    {
        foreach ($exceptionItem as $arrayOf_tns4_nillable_ExceptionItemExceptionItemItem) {
            // validation for constraint: itemType
            if (!$arrayOf_tns4_nillable_ExceptionItemExceptionItemItem instanceof \StructType\ExceptionObject) {
                throw new \InvalidArgumentException(sprintf('The ExceptionItem property can only contain items of \StructType\ExceptionObject, "%s" given', is_object($arrayOf_tns4_nillable_ExceptionItemExceptionItemItem) ? get_class($arrayOf_tns4_nillable_ExceptionItemExceptionItemItem) : gettype($arrayOf_tns4_nillable_ExceptionItemExceptionItemItem)), __LINE__);
            }
        }
        if (is_null($exceptionItem) || (is_array($exceptionItem) && empty($exceptionItem))) {
            unset($this->ExceptionItem);
        } else {
            $this->ExceptionItem = $exceptionItem;
        }
        return $this;
    }
    /**
     * Add item to ExceptionItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ExceptionObject $item
     * @return \ArrayType\ArrayOf_tns4_nillable_ExceptionItem
     */
    public function addToExceptionItem(\StructType\ExceptionObject $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExceptionObject) {
            throw new \InvalidArgumentException(sprintf('The ExceptionItem property can only contain items of \StructType\ExceptionObject, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ExceptionItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ExceptionObject|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ExceptionObject|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ExceptionObject|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ExceptionObject|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ExceptionObject|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ExceptionItem
     */
    public function getAttributeName()
    {
        return 'ExceptionItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOf_tns4_nillable_ExceptionItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
