<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProductInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfProductInfo extends AbstractStructArrayBase
{
    /**
     * The ProductInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProductInfo[]
     */
    public $ProductInfo;
    /**
     * Constructor method for ArrayOfProductInfo
     * @uses ArrayOfProductInfo::setProductInfo()
     * @param \StructType\ProductInfo[] $productInfo
     */
    public function __construct(array $productInfo = array())
    {
        $this
            ->setProductInfo($productInfo);
    }
    /**
     * Get ProductInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProductInfo[]|null
     */
    public function getProductInfo()
    {
        return isset($this->ProductInfo) ? $this->ProductInfo : null;
    }
    /**
     * Set ProductInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProductInfo[] $productInfo
     * @return \ArrayType\ArrayOfProductInfo
     */
    public function setProductInfo(array $productInfo = array())
    {
        foreach ($productInfo as $arrayOfProductInfoProductInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfProductInfoProductInfoItem instanceof \StructType\ProductInfo) {
                throw new \InvalidArgumentException(sprintf('The ProductInfo property can only contain items of \StructType\ProductInfo, "%s" given', is_object($arrayOfProductInfoProductInfoItem) ? get_class($arrayOfProductInfoProductInfoItem) : gettype($arrayOfProductInfoProductInfoItem)), __LINE__);
            }
        }
        if (is_null($productInfo) || (is_array($productInfo) && empty($productInfo))) {
            unset($this->ProductInfo);
        } else {
            $this->ProductInfo = $productInfo;
        }
        return $this;
    }
    /**
     * Add item to ProductInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductInfo $item
     * @return \ArrayType\ArrayOfProductInfo
     */
    public function addToProductInfo(\StructType\ProductInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductInfo) {
            throw new \InvalidArgumentException(sprintf('The ProductInfo property can only contain items of \StructType\ProductInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ProductInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProductInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProductInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProductInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProductInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProductInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductInfo
     */
    public function getAttributeName()
    {
        return 'ProductInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfProductInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
