<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://hermesapi.hlg.de/hermes-api-props-web/services/v15/ProPS?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://hermesapi.hlg.de/hermes-api-props-web/services/v15/ProPS?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Props ServiceType
 */
$props = new \ServiceType\Props($options);
$props->setSoapHeaderUserToken($UserToken);
/**
 * Sample call for propsGetPropsOrders operation/method
 */
if ($props->propsGetPropsOrders(new \StructType\PropsGetPropsOrders()) !== false) {
    print_r($props->getResult());
} else {
    print_r($props->getLastError());
}
/**
 * Sample call for propsProductlnformation operation/method
 */
if ($props->propsProductlnformation(new \StructType\PropsProductlnformation()) !== false) {
    print_r($props->getResult());
} else {
    print_r($props->getLastError());
}
/**
 * Sample call for propsCollectionRequest operation/method
 */
if ($props->propsCollectionRequest(new \StructType\PropsCollectionRequest()) !== false) {
    print_r($props->getResult());
} else {
    print_r($props->getLastError());
}
/**
 * Sample call for propsGetPropsOrder operation/method
 */
if ($props->propsGetPropsOrder(new \StructType\PropsGetPropsOrder()) !== false) {
    print_r($props->getResult());
} else {
    print_r($props->getLastError());
}
/**
 * Sample call for propsOrderSaveAndPrintLabelJpeg operation/method
 */
if ($props->propsOrderSaveAndPrintLabelJpeg(new \StructType\PropsOrderSaveAndPrintLabelJpeg()) !== false) {
    print_r($props->getResult());
} else {
    print_r($props->getLastError());
}
/**
 * Sample call for propsReadShipmentStatus operation/method
 */
if ($props->propsReadShipmentStatus(new \StructType\PropsReadShipmentStatus()) !== false) {
    print_r($props->getResult());
} else {
    print_r($props->getLastError());
}
/**
 * Sample call for propsOrderPrintLabelPdf operation/method
 */
if ($props->propsOrderPrintLabelPdf(new \StructType\PropsOrderPrintLabelPdf()) !== false) {
    print_r($props->getResult());
} else {
    print_r($props->getLastError());
}
/**
 * Sample call for propsCheckAvailability operation/method
 */
if ($props->propsCheckAvailability(new \StructType\PropsCheckAvailability()) !== false) {
    print_r($props->getResult());
} else {
    print_r($props->getLastError());
}
/**
 * Sample call for propsOrderSave operation/method
 */
if ($props->propsOrderSave(new \StructType\PropsOrderSave()) !== false) {
    print_r($props->getResult());
} else {
    print_r($props->getLastError());
}
/**
 * Sample call for propsOrdersPrintLabelsPdf operation/method
 */
if ($props->propsOrdersPrintLabelsPdf(new \StructType\PropsOrdersPrintLabelsPdf()) !== false) {
    print_r($props->getResult());
} else {
    print_r($props->getLastError());
}
/**
 * Sample call for propsCollectionCancel operation/method
 */
if ($props->propsCollectionCancel(new \StructType\PropsCollectionCancel()) !== false) {
    print_r($props->getResult());
} else {
    print_r($props->getLastError());
}
/**
 * Sample call for propsUserLogin operation/method
 */
if ($props->propsUserLogin(new \StructType\PropsUserLogin()) !== false) {
    print_r($props->getResult());
} else {
    print_r($props->getLastError());
}
/**
 * Sample call for propsOrderSaveAndPrintLabelPdf operation/method
 */
if ($props->propsOrderSaveAndPrintLabelPdf(new \StructType\PropsOrderSaveAndPrintLabelPdf()) !== false) {
    print_r($props->getResult());
} else {
    print_r($props->getLastError());
}
/**
 * Sample call for propsListOfProductsATG operation/method
 */
if ($props->propsListOfProductsATG(new \StructType\PropsListOfProductsATG()) !== false) {
    print_r($props->getResult());
} else {
    print_r($props->getLastError());
}
/**
 * Sample call for propsOrderDelete operation/method
 */
if ($props->propsOrderDelete(new \StructType\PropsOrderDelete()) !== false) {
    print_r($props->getResult());
} else {
    print_r($props->getLastError());
}
/**
 * Sample call for propsOrderPrintLabelJpeg operation/method
 */
if ($props->propsOrderPrintLabelJpeg(new \StructType\PropsOrderPrintLabelJpeg()) !== false) {
    print_r($props->getResult());
} else {
    print_r($props->getLastError());
}
/**
 * Sample call for propsGetCollectionOrders operation/method
 */
if ($props->propsGetCollectionOrders(new \StructType\PropsGetCollectionOrders()) !== false) {
    print_r($props->getResult());
} else {
    print_r($props->getLastError());
}
/**
 * Sample call for propsImportOrders operation/method
 */
if ($props->propsImportOrders(new \StructType\PropsImportOrders()) !== false) {
    print_r($props->getResult());
} else {
    print_r($props->getLastError());
}
