<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropsOrder StructType
 * @subpackage Structs
 */
class PropsOrder extends AbstractStructBase
{
    /**
     * The orderNo
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $orderNo;
    /**
     * The receiver
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Address
     */
    public $receiver;
    /**
     * The clientReferenceNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $clientReferenceNumber;
    /**
     * The parcelClass
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $parcelClass;
    /**
     * The amountCashOnDeliveryEurocent
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $amountCashOnDeliveryEurocent;
    /**
     * The includeCashOnDelivery
     * @var bool
     */
    public $includeCashOnDelivery;
    /**
     * The withBulkGoods
     * @var bool
     */
    public $withBulkGoods;
    /**
     * Constructor method for PropsOrder
     * @uses PropsOrder::setOrderNo()
     * @uses PropsOrder::setReceiver()
     * @uses PropsOrder::setClientReferenceNumber()
     * @uses PropsOrder::setParcelClass()
     * @uses PropsOrder::setAmountCashOnDeliveryEurocent()
     * @uses PropsOrder::setIncludeCashOnDelivery()
     * @uses PropsOrder::setWithBulkGoods()
     * @param string $orderNo
     * @param \StructType\Address $receiver
     * @param string $clientReferenceNumber
     * @param string $parcelClass
     * @param int $amountCashOnDeliveryEurocent
     * @param bool $includeCashOnDelivery
     * @param bool $withBulkGoods
     */
    public function __construct($orderNo = null, \StructType\Address $receiver = null, $clientReferenceNumber = null, $parcelClass = null, $amountCashOnDeliveryEurocent = null, $includeCashOnDelivery = null, $withBulkGoods = null)
    {
        $this
            ->setOrderNo($orderNo)
            ->setReceiver($receiver)
            ->setClientReferenceNumber($clientReferenceNumber)
            ->setParcelClass($parcelClass)
            ->setAmountCashOnDeliveryEurocent($amountCashOnDeliveryEurocent)
            ->setIncludeCashOnDelivery($includeCashOnDelivery)
            ->setWithBulkGoods($withBulkGoods);
    }
    /**
     * Get orderNo value
     * @return string|null
     */
    public function getOrderNo()
    {
        return $this->orderNo;
    }
    /**
     * Set orderNo value
     * @param string $orderNo
     * @return \StructType\PropsOrder
     */
    public function setOrderNo($orderNo = null)
    {
        // validation for constraint: string
        if (!is_null($orderNo) && !is_string($orderNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderNo)), __LINE__);
        }
        $this->orderNo = $orderNo;
        return $this;
    }
    /**
     * Get receiver value
     * @return \StructType\Address|null
     */
    public function getReceiver()
    {
        return $this->receiver;
    }
    /**
     * Set receiver value
     * @param \StructType\Address $receiver
     * @return \StructType\PropsOrder
     */
    public function setReceiver(\StructType\Address $receiver = null)
    {
        $this->receiver = $receiver;
        return $this;
    }
    /**
     * Get clientReferenceNumber value
     * @return string|null
     */
    public function getClientReferenceNumber()
    {
        return $this->clientReferenceNumber;
    }
    /**
     * Set clientReferenceNumber value
     * @param string $clientReferenceNumber
     * @return \StructType\PropsOrder
     */
    public function setClientReferenceNumber($clientReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($clientReferenceNumber) && !is_string($clientReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientReferenceNumber)), __LINE__);
        }
        $this->clientReferenceNumber = $clientReferenceNumber;
        return $this;
    }
    /**
     * Get parcelClass value
     * @return string|null
     */
    public function getParcelClass()
    {
        return $this->parcelClass;
    }
    /**
     * Set parcelClass value
     * @param string $parcelClass
     * @return \StructType\PropsOrder
     */
    public function setParcelClass($parcelClass = null)
    {
        // validation for constraint: string
        if (!is_null($parcelClass) && !is_string($parcelClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parcelClass)), __LINE__);
        }
        $this->parcelClass = $parcelClass;
        return $this;
    }
    /**
     * Get amountCashOnDeliveryEurocent value
     * @return int|null
     */
    public function getAmountCashOnDeliveryEurocent()
    {
        return $this->amountCashOnDeliveryEurocent;
    }
    /**
     * Set amountCashOnDeliveryEurocent value
     * @param int $amountCashOnDeliveryEurocent
     * @return \StructType\PropsOrder
     */
    public function setAmountCashOnDeliveryEurocent($amountCashOnDeliveryEurocent = null)
    {
        // validation for constraint: int
        if (!is_null($amountCashOnDeliveryEurocent) && !is_numeric($amountCashOnDeliveryEurocent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($amountCashOnDeliveryEurocent)), __LINE__);
        }
        $this->amountCashOnDeliveryEurocent = $amountCashOnDeliveryEurocent;
        return $this;
    }
    /**
     * Get includeCashOnDelivery value
     * @return bool|null
     */
    public function getIncludeCashOnDelivery()
    {
        return $this->includeCashOnDelivery;
    }
    /**
     * Set includeCashOnDelivery value
     * @param bool $includeCashOnDelivery
     * @return \StructType\PropsOrder
     */
    public function setIncludeCashOnDelivery($includeCashOnDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeCashOnDelivery) && !is_bool($includeCashOnDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeCashOnDelivery)), __LINE__);
        }
        $this->includeCashOnDelivery = $includeCashOnDelivery;
        return $this;
    }
    /**
     * Get withBulkGoods value
     * @return bool|null
     */
    public function getWithBulkGoods()
    {
        return $this->withBulkGoods;
    }
    /**
     * Set withBulkGoods value
     * @param bool $withBulkGoods
     * @return \StructType\PropsOrder
     */
    public function setWithBulkGoods($withBulkGoods = null)
    {
        // validation for constraint: boolean
        if (!is_null($withBulkGoods) && !is_bool($withBulkGoods)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($withBulkGoods)), __LINE__);
        }
        $this->withBulkGoods = $withBulkGoods;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PropsOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
