<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParcelFormat StructType
 * @subpackage Structs
 */
class ParcelFormat extends AbstractStructBase
{
    /**
     * The parcelClass
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $parcelClass;
    /**
     * The shortestPlusLongestEdgeCmMax
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $shortestPlusLongestEdgeCmMax;
    /**
     * The shortestPlusLongestEdgeCmMin
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $shortestPlusLongestEdgeCmMin;
    /**
     * The thridEdgeCmMax
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $thridEdgeCmMax;
    /**
     * Constructor method for ParcelFormat
     * @uses ParcelFormat::setParcelClass()
     * @uses ParcelFormat::setShortestPlusLongestEdgeCmMax()
     * @uses ParcelFormat::setShortestPlusLongestEdgeCmMin()
     * @uses ParcelFormat::setThridEdgeCmMax()
     * @param string $parcelClass
     * @param int $shortestPlusLongestEdgeCmMax
     * @param int $shortestPlusLongestEdgeCmMin
     * @param int $thridEdgeCmMax
     */
    public function __construct($parcelClass = null, $shortestPlusLongestEdgeCmMax = null, $shortestPlusLongestEdgeCmMin = null, $thridEdgeCmMax = null)
    {
        $this
            ->setParcelClass($parcelClass)
            ->setShortestPlusLongestEdgeCmMax($shortestPlusLongestEdgeCmMax)
            ->setShortestPlusLongestEdgeCmMin($shortestPlusLongestEdgeCmMin)
            ->setThridEdgeCmMax($thridEdgeCmMax);
    }
    /**
     * Get parcelClass value
     * @return string|null
     */
    public function getParcelClass()
    {
        return $this->parcelClass;
    }
    /**
     * Set parcelClass value
     * @param string $parcelClass
     * @return \StructType\ParcelFormat
     */
    public function setParcelClass($parcelClass = null)
    {
        // validation for constraint: string
        if (!is_null($parcelClass) && !is_string($parcelClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parcelClass)), __LINE__);
        }
        $this->parcelClass = $parcelClass;
        return $this;
    }
    /**
     * Get shortestPlusLongestEdgeCmMax value
     * @return int|null
     */
    public function getShortestPlusLongestEdgeCmMax()
    {
        return $this->shortestPlusLongestEdgeCmMax;
    }
    /**
     * Set shortestPlusLongestEdgeCmMax value
     * @param int $shortestPlusLongestEdgeCmMax
     * @return \StructType\ParcelFormat
     */
    public function setShortestPlusLongestEdgeCmMax($shortestPlusLongestEdgeCmMax = null)
    {
        // validation for constraint: int
        if (!is_null($shortestPlusLongestEdgeCmMax) && !is_numeric($shortestPlusLongestEdgeCmMax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($shortestPlusLongestEdgeCmMax)), __LINE__);
        }
        $this->shortestPlusLongestEdgeCmMax = $shortestPlusLongestEdgeCmMax;
        return $this;
    }
    /**
     * Get shortestPlusLongestEdgeCmMin value
     * @return int|null
     */
    public function getShortestPlusLongestEdgeCmMin()
    {
        return $this->shortestPlusLongestEdgeCmMin;
    }
    /**
     * Set shortestPlusLongestEdgeCmMin value
     * @param int $shortestPlusLongestEdgeCmMin
     * @return \StructType\ParcelFormat
     */
    public function setShortestPlusLongestEdgeCmMin($shortestPlusLongestEdgeCmMin = null)
    {
        // validation for constraint: int
        if (!is_null($shortestPlusLongestEdgeCmMin) && !is_numeric($shortestPlusLongestEdgeCmMin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($shortestPlusLongestEdgeCmMin)), __LINE__);
        }
        $this->shortestPlusLongestEdgeCmMin = $shortestPlusLongestEdgeCmMin;
        return $this;
    }
    /**
     * Get thridEdgeCmMax value
     * @return int|null
     */
    public function getThridEdgeCmMax()
    {
        return $this->thridEdgeCmMax;
    }
    /**
     * Set thridEdgeCmMax value
     * @param int $thridEdgeCmMax
     * @return \StructType\ParcelFormat
     */
    public function setThridEdgeCmMax($thridEdgeCmMax = null)
    {
        // validation for constraint: int
        if (!is_null($thridEdgeCmMax) && !is_numeric($thridEdgeCmMax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($thridEdgeCmMax)), __LINE__);
        }
        $this->thridEdgeCmMax = $thridEdgeCmMax;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ParcelFormat
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
