<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderResponse StructType
 * @subpackage Structs
 */
class OrderResponse extends AbstractStructBase
{
    /**
     * The orderNo
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $orderNo;
    /**
     * The exceptionItems
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOf_tns4_nillable_ExceptionItem
     */
    public $exceptionItems;
    /**
     * Constructor method for OrderResponse
     * @uses OrderResponse::setOrderNo()
     * @uses OrderResponse::setExceptionItems()
     * @param string $orderNo
     * @param \ArrayType\ArrayOf_tns4_nillable_ExceptionItem $exceptionItems
     */
    public function __construct($orderNo = null, \ArrayType\ArrayOf_tns4_nillable_ExceptionItem $exceptionItems = null)
    {
        $this
            ->setOrderNo($orderNo)
            ->setExceptionItems($exceptionItems);
    }
    /**
     * Get orderNo value
     * @return string|null
     */
    public function getOrderNo()
    {
        return $this->orderNo;
    }
    /**
     * Set orderNo value
     * @param string $orderNo
     * @return \StructType\OrderResponse
     */
    public function setOrderNo($orderNo = null)
    {
        // validation for constraint: string
        if (!is_null($orderNo) && !is_string($orderNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderNo)), __LINE__);
        }
        $this->orderNo = $orderNo;
        return $this;
    }
    /**
     * Get exceptionItems value
     * @return \ArrayType\ArrayOf_tns4_nillable_ExceptionItem|null
     */
    public function getExceptionItems()
    {
        return $this->exceptionItems;
    }
    /**
     * Set exceptionItems value
     * @param \ArrayType\ArrayOf_tns4_nillable_ExceptionItem $exceptionItems
     * @return \StructType\OrderResponse
     */
    public function setExceptionItems(\ArrayType\ArrayOf_tns4_nillable_ExceptionItem $exceptionItems = null)
    {
        $this->exceptionItems = $exceptionItems;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
